/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.admin.oauth;

import java.io.Serializable;
import org.apache.openmeetings.db.dao.server.OAuth2Dao;
import org.apache.openmeetings.db.entity.server.OAuthServer;
import org.apache.openmeetings.web.admin.AdminBasePanel;
import org.apache.openmeetings.web.admin.SearchableDataView;
import org.apache.openmeetings.web.admin.oauth.OAuthForm;
import org.apache.openmeetings.web.common.PagedEntityListPanel;
import org.apache.openmeetings.web.data.DataViewContainer;
import org.apache.openmeetings.web.data.OmOrderByBorder;
import org.apache.openmeetings.web.data.SearchableDataProvider;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.repeater.Item;
import org.danekja.java.util.function.serializable.SerializableConsumer;

public class OAuthPanel
extends AdminBasePanel {
    private static final long serialVersionUID = 1L;
    final WebMarkupContainer listContainer = new WebMarkupContainer("listContainer");
    private OAuthForm form;

    public OAuthPanel(String id) {
        super(id);
    }

    protected void onInitialize() {
        super.onInitialize();
        SearchableDataView<OAuthServer> dataView = new SearchableDataView<OAuthServer>("oauthServersList", new SearchableDataProvider(OAuth2Dao.class)){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<OAuthServer> item) {
                OAuthServer server = (OAuthServer)item.getModelObject();
                item.add(new Component[]{new Label("id")});
                item.add(new Component[]{new Label("name")});
                item.add(new Behavior[]{AjaxEventBehavior.onEvent((String)"click", (SerializableConsumer & Serializable)target -> {
                    OAuthPanel.this.form.setModelObject(server);
                    OAuthPanel.this.form.setNewRecordVisible(false);
                    target.add(new Component[]{OAuthPanel.this.form, OAuthPanel.this.listContainer});
                })});
                item.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)OAuthPanel.this.getRowClass(server.getId(), ((OAuthServer)OAuthPanel.this.form.getModelObject()).getId()))});
            }
        };
        this.add(new Component[]{this.listContainer.add(new Component[]{dataView}).setOutputMarkupId(true)});
        PagedEntityListPanel navigator = new PagedEntityListPanel("navigator", dataView){
            private static final long serialVersionUID = 1L;

            @Override
            protected void onEvent(AjaxRequestTarget target) {
                target.add(new Component[]{OAuthPanel.this.listContainer});
            }
        };
        DataViewContainer<OAuthServer> container = new DataViewContainer<OAuthServer>(this.listContainer, dataView, navigator);
        container.addLink(new OmOrderByBorder<OAuthServer>("orderById", "id", container)).addLink(new OmOrderByBorder<OAuthServer>("orderByName", "name", container));
        this.add((Component[])container.getLinks());
        this.add(new Component[]{navigator});
        this.form = new OAuthForm("form", this.listContainer, new OAuthServer());
        this.add(new Component[]{this.form});
    }
}

