/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.action;

import java.util.HashMap;
import java.util.Map;
import org.asteriskjava.manager.action.AbstractManagerAction;

public class UpdateConfigAction
extends AbstractManagerAction {
    static final long serialVersionUID = 4753117770471622025L;
    private static final String RELOAD_STRING_YES = "Yes";
    private static final String RELOAD_STRING_NO = "No";
    public static final String ACTION_NEWCAT = "NewCat";
    public static final String ACTION_RENAMECAT = "RenameCat";
    public static final String ACTION_DELCAT = "DelCat";
    public static final String ACTION_UPDATE = "Update";
    public static final String ACTION_DELETE = "Delete";
    public static final String ACTION_APPEND = "Append";
    protected String srcFilename;
    protected String dstFilename;
    protected String reload;
    protected int actionCounter = 0;
    protected Map<String, String> actions;

    public UpdateConfigAction() {
        this.actions = new HashMap<String, String>();
    }

    public UpdateConfigAction(String srcFilename, String dstFilename, boolean reload) {
        this.srcFilename = srcFilename;
        this.dstFilename = dstFilename;
        this.setReload(reload);
        this.actions = new HashMap<String, String>();
    }

    public void addCommand(String action, String cat, String var, String value, String match) {
        String stringCounter = String.format("%06d", this.actionCounter);
        if (action != null) {
            this.actions.put("Action-" + stringCounter, action);
        }
        if (cat != null) {
            this.actions.put("Cat-" + stringCounter, cat);
        }
        if (var != null) {
            this.actions.put("Var-" + stringCounter, var);
        }
        if (value != null) {
            this.actions.put("Value-" + stringCounter, value);
        }
        if (match != null) {
            this.actions.put("Match-" + stringCounter, match);
        }
        ++this.actionCounter;
    }

    @Override
    public String getAction() {
        return "UpdateConfig";
    }

    public String getSrcFilename() {
        return this.srcFilename;
    }

    public void setSrcFilename(String filename) {
        this.srcFilename = filename;
    }

    public String getDstFilename() {
        return this.dstFilename;
    }

    public void setDstFilename(String filename) {
        this.dstFilename = filename;
    }

    public String getReload() {
        return this.reload;
    }

    public void setReload(String reload) {
        this.reload = reload;
    }

    public void setReload(boolean reload) {
        this.reload = reload ? RELOAD_STRING_YES : RELOAD_STRING_NO;
    }

    public Map<String, String> getAttributes() {
        return this.actions;
    }

    public void setAttributes(Map<String, String> actions) {
        this.actions = actions;
        this.actionCounter = actions.keySet().size();
    }
}

