/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.event;

import java.net.InetAddress;
import org.asteriskjava.manager.event.AbstractRtcpEvent;

public class RtcpReceivedEvent
extends AbstractRtcpEvent {
    private static final long serialVersionUID = 2L;
    public static final int PT_SENDER_REPORT = 200;
    public static final int PT_RECEIVER_REPORT = 201;
    public static final int PT_H261_FUR = 192;
    private InetAddress fromAddress;
    private Integer fromPort;
    private Long pt;
    private Long receptionReports;
    private Long senderSsrc;
    private Long packetsLost;
    private Long highestSequence;
    private Long sequenceNumberCycles;
    private Double lastSr;
    private Double rtt;
    private String channel;
    private String language;
    private String report0SequenceNumberCycles;
    private String ssrc;
    private String linkedId;
    private String report0lsr;
    private Long sentOctets;
    private String report0Sourcessrc;
    private Double report0dlsr;
    private String uniqueid;
    private Integer reportCount;
    private Integer report0CumulativeLost;
    private Integer report0FractionLost;
    private Long report0iaJitter;
    private Integer report0HighestSequence;
    private InetAddress toAddress;
    private Integer toPort;
    private String sentntp;
    private Long sentPackets;
    private Long sentrtp;
    private String accountCode;
    private Double mes;

    public RtcpReceivedEvent(Object source) {
        super(source);
    }

    public InetAddress getFromAddress() {
        return this.fromAddress;
    }

    public Integer getFromPort() {
        return this.fromPort;
    }

    public void setFrom(String from) {
        this.fromAddress = this.stringToAddress(from);
        this.fromPort = this.stringToPort(from);
    }

    public Integer getToPort() {
        return this.toPort;
    }

    public void setTo(String to) {
        this.toAddress = this.stringToAddress(to);
        this.toPort = this.stringToPort(to);
    }

    public Long getPt() {
        return this.pt;
    }

    public void setPt(String ptString) {
        if (ptString == null || ptString.length() == 0) {
            this.pt = null;
            return;
        }
        try {
            this.pt = ptString.indexOf(40) > 0 ? Long.valueOf(Long.parseLong(ptString.substring(0, ptString.indexOf(40)))) : Long.valueOf(Long.parseLong(ptString));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException(String.format("Input string [%s] is not a parsable long", ptString));
        }
    }

    public Long getReceptionReports() {
        return this.receptionReports;
    }

    public void setReceptionReports(Long receptionReports) {
        this.receptionReports = receptionReports;
    }

    public Long getSenderSsrc() {
        return this.senderSsrc;
    }

    public void setSenderSsrc(Long senderSsrc) {
        this.senderSsrc = senderSsrc;
    }

    public Long getPacketsLost() {
        return this.packetsLost;
    }

    public void setPacketsLost(Long packetsLost) {
        this.packetsLost = packetsLost;
    }

    public Long getHighestSequence() {
        return this.highestSequence;
    }

    public void setHighestSequence(Long highestSequence) {
        this.highestSequence = highestSequence;
    }

    public Long getSequenceNumberCycles() {
        return this.sequenceNumberCycles;
    }

    public void setSequenceNumberCycles(Long sequenceNumberCycles) {
        this.sequenceNumberCycles = sequenceNumberCycles;
    }

    public Double getLastSr() {
        return this.lastSr;
    }

    public void setLastSr(Double lastSr) {
        this.lastSr = lastSr;
    }

    public Double getRtt() {
        return this.rtt;
    }

    public void setRtt(String rttString) {
        this.rtt = this.secStringToDouble(rttString);
    }

    public Long getRttAsMillseconds() {
        return (long)(this.rtt * 1000.0);
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getReport0SequenceNumberCycles() {
        return this.report0SequenceNumberCycles;
    }

    public void setReport0SequenceNumberCycles(String report0SequenceNumberCycles) {
        this.report0SequenceNumberCycles = report0SequenceNumberCycles;
    }

    public String getSsrc() {
        return this.ssrc;
    }

    public void setSsrc(String ssrc) {
        this.ssrc = ssrc;
    }

    public String getReport0lsr() {
        return this.report0lsr;
    }

    public void setReport0lsr(String report0lsr) {
        this.report0lsr = report0lsr;
    }

    public Long getSentOctets() {
        return this.sentOctets;
    }

    public void setSentOctets(Long sentOctets) {
        this.sentOctets = sentOctets;
    }

    public String getReport0Sourcessrc() {
        return this.report0Sourcessrc;
    }

    public void setReport0Sourcessrc(String report0Sourcessrc) {
        this.report0Sourcessrc = report0Sourcessrc;
    }

    public Double getReport0dlsr() {
        return this.report0dlsr;
    }

    public void setReport0dlsr(Double report0dlsr) {
        this.report0dlsr = report0dlsr;
    }

    public String getUniqueid() {
        return this.uniqueid;
    }

    public void setUniqueid(String uniqueid) {
        this.uniqueid = uniqueid;
    }

    public Integer getReport0CumulativeLost() {
        return this.report0CumulativeLost;
    }

    public void setReport0CumulativeLost(Integer report0CumulativeLost) {
        this.report0CumulativeLost = report0CumulativeLost;
    }

    public Integer getReport0FractionLost() {
        return this.report0FractionLost;
    }

    public void setReport0FractionLost(Integer report0FractionLost) {
        this.report0FractionLost = report0FractionLost;
    }

    public Long getReport0iaJitter() {
        return this.report0iaJitter;
    }

    public void setReport0iaJitter(Long report0iaJitter) {
        this.report0iaJitter = report0iaJitter;
    }

    public InetAddress getToAddress() {
        return this.toAddress;
    }

    public String getSentntp() {
        return this.sentntp;
    }

    public void setSentntp(String sentntp) {
        this.sentntp = sentntp;
    }

    public Long getSentrtp() {
        return this.sentrtp;
    }

    public void setSentrtp(Long sentrtp) {
        this.sentrtp = sentrtp;
    }

    public Integer getReportCount() {
        return this.reportCount;
    }

    public void setReportCount(Integer reportCount) {
        this.reportCount = reportCount;
    }

    public Integer getReport0HighestSequence() {
        return this.report0HighestSequence;
    }

    public void setReport0HighestSequence(Integer report0HighestSequence) {
        this.report0HighestSequence = report0HighestSequence;
    }

    public String getLinkedId() {
        return this.linkedId;
    }

    public void setLinkedId(String linkedId) {
        this.linkedId = linkedId;
    }

    public Long getSentPackets() {
        return this.sentPackets;
    }

    public void setSentPackets(Long sentPackets) {
        this.sentPackets = sentPackets;
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public void setAccountCode(String accountCode) {
        this.accountCode = accountCode;
    }

    public Double getMes() {
        return this.mes;
    }

    public void setMes(Double mes) {
        this.mes = mes;
    }
}

