/*
 * Decompiled with CFR 0.152.
 */
package org.netpreserve.jwarc;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.netpreserve.jwarc.MediaType;
import org.netpreserve.jwarc.WarcFilterLexer;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcRequest;
import org.netpreserve.jwarc.WarcResponse;

class WarcFilterCompiler {
    private final WarcFilterLexer lexer;

    WarcFilterCompiler(String expression) {
        this.lexer = new WarcFilterLexer(expression);
    }

    Predicate<WarcRecord> predicate() {
        Predicate<WarcRecord> lhs = this.unary();
        if (this.lexer.atEnd()) {
            return lhs;
        }
        String operator = this.lexer.peekOperator();
        if (operator == null) {
            throw this.lexer.error("expected operator");
        }
        switch (operator) {
            case ")": {
                return lhs;
            }
            case "&&": {
                this.lexer.advance();
                return lhs.and(this.predicate());
            }
            case "||": {
                this.lexer.advance();
                return lhs.or(this.predicate());
            }
        }
        throw this.lexer.error("operator not allowed here: " + operator);
    }

    private Predicate<WarcRecord> unary() {
        String operator = this.lexer.peekOperator();
        if (operator == null) {
            return this.comparison();
        }
        if (operator.equals("!(") || operator.equals("(")) {
            this.lexer.advance();
            Predicate<WarcRecord> predicate = this.predicate();
            if (!")".equals(this.lexer.operator())) {
                throw this.lexer.error("')' expected");
            }
            return operator.startsWith("!") ? predicate.negate() : predicate;
        }
        throw this.lexer.error("operator not allowed here: " + operator);
    }

    private Predicate<WarcRecord> comparison() {
        Accessor lhs = this.accessor(this.lexer.token());
        String operator = this.lexer.operator();
        if (operator == null) {
            throw this.lexer.error("expected operator");
        }
        switch (operator) {
            case "==": 
            case "!=": {
                Predicate<WarcRecord> pred;
                Object rhs = this.lexer.stringOrNumber();
                if (rhs instanceof String) {
                    pred = rec -> lhs.string((WarcRecord)rec).equals(rhs);
                } else {
                    long value = (Long)rhs;
                    pred = rec -> lhs.integer((WarcRecord)rec) == value;
                }
                return operator.equals("!=") ? pred.negate() : pred;
            }
            case "=~": {
                Pattern pattern = Pattern.compile(this.lexer.string());
                return rec -> pattern.matcher(lhs.string((WarcRecord)rec)).matches();
            }
            case "!~": {
                Pattern pattern = Pattern.compile(this.lexer.string());
                return rec -> !pattern.matcher(lhs.string((WarcRecord)rec)).matches();
            }
            case "<": {
                long value = Long.parseLong(this.lexer.token());
                return rec -> lhs.integer((WarcRecord)rec) < value;
            }
            case "<=": {
                long value = Long.parseLong(this.lexer.token());
                return rec -> lhs.integer((WarcRecord)rec) <= value;
            }
            case ">=": {
                long value = Long.parseLong(this.lexer.token());
                return rec -> lhs.integer((WarcRecord)rec) >= value;
            }
            case ">": {
                long value = Long.parseLong(this.lexer.token());
                return rec -> lhs.integer((WarcRecord)rec) > value;
            }
        }
        throw this.lexer.error("operator not allowed here: " + operator);
    }

    private Accessor accessor(String token) {
        if (":status".equals(token)) {
            return record -> {
                try {
                    if (!(record instanceof WarcResponse)) {
                        return Optional.empty();
                    }
                    if (!record.contentType().equals(MediaType.HTTP_RESPONSE)) {
                        return Optional.empty();
                    }
                    return Optional.of(Integer.toString(((WarcResponse)record).http().status()));
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            };
        }
        if (token.startsWith("http:")) {
            String field = token.substring("http:".length());
            return record -> {
                try {
                    if (record instanceof WarcRequest && record.contentType().equals(MediaType.HTTP_REQUEST)) {
                        return ((WarcRequest)record).http().headers().first(field);
                    }
                    if (record instanceof WarcResponse && record.contentType().equals(MediaType.HTTP_RESPONSE)) {
                        return ((WarcResponse)record).http().headers().first(field);
                    }
                    return Optional.empty();
                }
                catch (Exception e) {
                    return Optional.empty();
                }
            };
        }
        return record -> record.headers().first(token);
    }

    private static interface Accessor {
        public Optional<String> raw(WarcRecord var1);

        default public String string(WarcRecord record) {
            return this.raw(record).orElse("");
        }

        default public long integer(WarcRecord record) {
            try {
                return Long.parseLong(this.raw(record).orElse("0"));
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
    }
}

