/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.UnionColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.TypeDescription;
import org.apache.orc.impl.MaskDescriptionImpl;
import org.apache.orc.impl.SchemaEvolution;

public class ParserUtils {
    private static final Pattern INTEGER_PATTERN = Pattern.compile("^[0-9]+$");

    static TypeDescription.Category parseCategory(StringPosition source) {
        StringBuilder word = new StringBuilder();
        boolean hadSpace = true;
        while (source.position < source.length) {
            char ch = source.value.charAt(source.position);
            if (Character.isLetter(ch)) {
                word.append(Character.toLowerCase(ch));
                hadSpace = false;
            } else {
                if (ch != ' ') break;
                if (!hadSpace) {
                    hadSpace = true;
                    word.append(ch);
                }
            }
            ++source.position;
        }
        String catString = word.toString();
        if (hadSpace) {
            catString = catString.trim();
        }
        if (!catString.isEmpty()) {
            for (TypeDescription.Category cat : TypeDescription.Category.values()) {
                if (!cat.getName().equals(catString)) continue;
                return cat;
            }
        }
        throw new IllegalArgumentException("Can't parse category at " + source);
    }

    static int parseInt(StringPosition source) {
        char ch;
        int start = source.position;
        int result = 0;
        while (source.position < source.length && Character.isDigit(ch = source.value.charAt(source.position))) {
            result = result * 10 + (ch - 48);
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing integer at " + source);
        }
        return result;
    }

    public static String parseName(StringPosition source) {
        char ch;
        if (source.position == source.length) {
            throw new IllegalArgumentException("Missing name at " + source);
        }
        int start = source.position;
        if (source.value.charAt(source.position) == '`') {
            ++source.position;
            StringBuilder buffer = new StringBuilder();
            boolean closed = false;
            while (source.position < source.length) {
                char ch2 = source.value.charAt(source.position);
                ++source.position;
                if (ch2 == '`') {
                    if (source.position < source.length && source.value.charAt(source.position) == '`') {
                        ++source.position;
                        buffer.append('`');
                        continue;
                    }
                    closed = true;
                    break;
                }
                buffer.append(ch2);
            }
            if (!closed) {
                source.position = start;
                throw new IllegalArgumentException("Unmatched quote at " + source);
            }
            if (buffer.length() == 0) {
                throw new IllegalArgumentException("Empty quoted field name at " + source);
            }
            return buffer.toString();
        }
        while (source.position < source.length && (Character.isLetterOrDigit(ch = source.value.charAt(source.position)) || ch == '_')) {
            ++source.position;
        }
        if (source.position == start) {
            throw new IllegalArgumentException("Missing name at " + source);
        }
        return source.value.substring(start, source.position);
    }

    static void requireChar(StringPosition source, char required) {
        if (source.position >= source.length || source.value.charAt(source.position) != required) {
            throw new IllegalArgumentException("Missing required char '" + required + "' at " + source);
        }
        ++source.position;
    }

    private static boolean consumeChar(StringPosition source, char ch) {
        boolean result;
        boolean bl = result = source.position < source.length && source.value.charAt(source.position) == ch;
        if (result) {
            ++source.position;
        }
        return result;
    }

    private static void parseUnion(TypeDescription type, StringPosition source) {
        ParserUtils.requireChar(source, '<');
        do {
            type.addUnionChild(ParserUtils.parseType(source));
        } while (ParserUtils.consumeChar(source, ','));
        ParserUtils.requireChar(source, '>');
    }

    private static void parseStruct(TypeDescription type, StringPosition source) {
        ParserUtils.requireChar(source, '<');
        boolean needComma = false;
        while (!ParserUtils.consumeChar(source, '>')) {
            if (needComma) {
                ParserUtils.requireChar(source, ',');
            } else {
                needComma = true;
            }
            String fieldName = ParserUtils.parseName(source);
            ParserUtils.requireChar(source, ':');
            type.addField(fieldName, ParserUtils.parseType(source));
        }
    }

    public static TypeDescription parseType(StringPosition source) {
        TypeDescription result = new TypeDescription(ParserUtils.parseCategory(source));
        switch (result.getCategory()) {
            case BINARY: 
            case BOOLEAN: 
            case BYTE: 
            case DATE: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case SHORT: 
            case STRING: 
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                break;
            }
            case CHAR: 
            case VARCHAR: {
                ParserUtils.requireChar(source, '(');
                result.withMaxLength(ParserUtils.parseInt(source));
                ParserUtils.requireChar(source, ')');
                break;
            }
            case DECIMAL: {
                ParserUtils.requireChar(source, '(');
                int precision = ParserUtils.parseInt(source);
                ParserUtils.requireChar(source, ',');
                result.withScale(ParserUtils.parseInt(source));
                result.withPrecision(precision);
                ParserUtils.requireChar(source, ')');
                break;
            }
            case LIST: {
                ParserUtils.requireChar(source, '<');
                TypeDescription child = ParserUtils.parseType(source);
                result.addChild(child);
                ParserUtils.requireChar(source, '>');
                break;
            }
            case MAP: {
                ParserUtils.requireChar(source, '<');
                TypeDescription keyType = ParserUtils.parseType(source);
                result.addChild(keyType);
                ParserUtils.requireChar(source, ',');
                TypeDescription valueType = ParserUtils.parseType(source);
                result.addChild(valueType);
                ParserUtils.requireChar(source, '>');
                break;
            }
            case UNION: {
                ParserUtils.parseUnion(result, source);
                break;
            }
            case STRUCT: {
                ParserUtils.parseStruct(result, source);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown type " + (Object)((Object)result.getCategory()) + " at " + source);
            }
        }
        return result;
    }

    private static List<String> splitName(StringPosition source) {
        ArrayList<String> result = new ArrayList<String>();
        do {
            result.add(ParserUtils.parseName(source));
        } while (ParserUtils.consumeChar(source, '.'));
        return result;
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source) {
        return ParserUtils.findSubtype(schema, source, true);
    }

    public static TypeDescription findSubtype(TypeDescription schema, StringPosition source, boolean isSchemaEvolutionCaseAware) {
        TypeFinder result = new TypeFinder(ParserUtils.removeAcid(schema));
        ParserUtils.findColumn(result.current, source, isSchemaEvolutionCaseAware, (TypeVisitor)result);
        return result.current;
    }

    private static TypeDescription removeAcid(TypeDescription schema) {
        return SchemaEvolution.checkAcidSchema(schema) ? SchemaEvolution.getBaseRow(schema) : schema;
    }

    private static int findCaseInsensitive(List<String> list, String goal) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equalsIgnoreCase(goal)) continue;
            return i;
        }
        return -1;
    }

    public static void findSubtype(TypeDescription schema, int goal, TypeVisitor visitor) {
        TypeDescription current = schema;
        int id = schema.getId();
        if (goal < id || goal > schema.getMaximumId()) {
            throw new IllegalArgumentException("Unknown type id " + goal + " in " + current.toJson());
        }
        while (id != goal) {
            List<TypeDescription> children = current.getChildren();
            for (int i = 0; i < children.size(); ++i) {
                TypeDescription child = children.get(i);
                if (goal > child.getMaximumId()) continue;
                current = child;
                visitor.visit(current, i);
                break;
            }
            id = current.getId();
        }
    }

    public static void findColumn(TypeDescription schema, StringPosition source, boolean isSchemaEvolutionCaseAware, TypeVisitor visitor) {
        ParserUtils.findColumn(schema, ParserUtils.splitName(source), isSchemaEvolutionCaseAware, visitor);
    }

    public static void findColumn(TypeDescription schema, List<String> names, boolean isSchemaEvolutionCaseAware, TypeVisitor visitor) {
        if (names.size() == 1 && INTEGER_PATTERN.matcher(names.get(0)).matches()) {
            ParserUtils.findSubtype(schema, Integer.parseInt(names.get(0)), visitor);
            return;
        }
        TypeDescription current = schema;
        while (names.size() > 0) {
            int posn;
            String first = names.remove(0);
            switch (current.getCategory()) {
                case STRUCT: {
                    posn = isSchemaEvolutionCaseAware ? current.getFieldNames().indexOf(first) : ParserUtils.findCaseInsensitive(current.getFieldNames(), first);
                    break;
                }
                case LIST: {
                    if (first.equals("_elem")) {
                        posn = 0;
                        break;
                    }
                    posn = -1;
                    break;
                }
                case MAP: {
                    if (first.equals("_key")) {
                        posn = 0;
                        break;
                    }
                    if (first.equals("_value")) {
                        posn = 1;
                        break;
                    }
                    posn = -1;
                    break;
                }
                case UNION: {
                    try {
                        posn = Integer.parseInt(first);
                        if (posn < 0 || posn >= current.getChildren().size()) {
                            throw new NumberFormatException("off end of union");
                        }
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Field " + first + "not found in " + current.toString(), e);
                    }
                }
                default: {
                    posn = -1;
                }
            }
            if (posn < 0) {
                throw new IllegalArgumentException("Field " + first + " not found in " + current.toString());
            }
            current = current.getChildren().get(posn);
            visitor.visit(current, posn);
        }
    }

    public static ColumnVector[] findColumnVectors(TypeDescription schema, StringPosition source, boolean isCaseSensitive, VectorizedRowBatch batch) {
        List<String> names = ParserUtils.splitName(source);
        TypeDescription schemaToUse = ParserUtils.removeAcid(schema);
        ColumnVector[] columnVectors = SchemaEvolution.checkAcidSchema(schema) ? ((StructColumnVector)batch.cols[batch.cols.length - 1]).fields : batch.cols;
        ColumnFinder result = new ColumnFinder(schemaToUse, columnVectors, names.size());
        ParserUtils.findColumn(schemaToUse, names, isCaseSensitive, (TypeVisitor)result);
        return result.result;
    }

    public static List<TypeDescription> findSubtypeList(TypeDescription schema, StringPosition source) {
        ArrayList<TypeDescription> result = new ArrayList<TypeDescription>();
        if (source.hasCharactersLeft()) {
            do {
                result.add(ParserUtils.findSubtype(schema, source));
            } while (ParserUtils.consumeChar(source, ','));
        }
        return result;
    }

    public static void parseKeys(StringPosition source, TypeDescription schema) {
        if (source.hasCharactersLeft()) {
            do {
                String keyName = ParserUtils.parseName(source);
                ParserUtils.requireChar(source, ':');
                for (TypeDescription field : ParserUtils.findSubtypeList(schema, source)) {
                    String prev = field.getAttributeValue("encrypt");
                    if (prev != null && !prev.equals(keyName)) {
                        throw new IllegalArgumentException("Conflicting encryption keys " + keyName + " and " + prev);
                    }
                    field.setAttribute("encrypt", keyName);
                }
            } while (ParserUtils.consumeChar(source, ';'));
        }
    }

    public static void parseMasks(StringPosition source, TypeDescription schema) {
        if (source.hasCharactersLeft()) {
            do {
                int start = source.position;
                ParserUtils.parseName(source);
                while (ParserUtils.consumeChar(source, ',')) {
                    ParserUtils.parseName(source);
                }
                String maskString = source.fromPosition(start);
                ParserUtils.requireChar(source, ':');
                for (TypeDescription field : ParserUtils.findSubtypeList(schema, source)) {
                    String prev = field.getAttributeValue("mask");
                    if (prev != null && !prev.equals(maskString)) {
                        throw new IllegalArgumentException("Conflicting encryption masks " + maskString + " and " + prev);
                    }
                    field.setAttribute("mask", maskString);
                }
            } while (ParserUtils.consumeChar(source, ';'));
        }
    }

    public static MaskDescriptionImpl buildMaskDescription(String value) {
        StringPosition source = new StringPosition(value);
        String maskName = ParserUtils.parseName(source);
        ArrayList<String> params = new ArrayList<String>();
        while (ParserUtils.consumeChar(source, ',')) {
            params.add(ParserUtils.parseName(source));
        }
        return new MaskDescriptionImpl(maskName, params.toArray(new String[0]));
    }

    public static class StringPosition {
        final String value;
        int position;
        final int length;

        public StringPosition(String value) {
            this.value = value == null ? "" : value;
            this.position = 0;
            this.length = this.value.length();
        }

        public String toString() {
            return '\'' + this.value.substring(0, this.position) + '^' + this.value.substring(this.position) + '\'';
        }

        public String fromPosition(int start) {
            return this.value.substring(start, this.position);
        }

        public boolean hasCharactersLeft() {
            return this.position != this.length;
        }
    }

    static class ColumnFinder
    implements TypeVisitor {
        private ColumnVector[] top;
        private ColumnVector current = null;
        private final ColumnVector[] result;
        private int resultIdx = 0;

        ColumnFinder(TypeDescription schema, ColumnVector[] columnVectors, int levels) {
            if (schema.getCategory() == TypeDescription.Category.STRUCT) {
                this.top = columnVectors;
                this.result = new ColumnVector[levels];
            } else {
                this.result = new ColumnVector[levels + 1];
                this.current = columnVectors[0];
                this.top = null;
                this.addResult(this.current);
            }
        }

        ColumnFinder(TypeDescription schema, VectorizedRowBatch vectorizedRowBatch, int levels) {
            this(schema, vectorizedRowBatch.cols, levels);
        }

        private void addResult(ColumnVector vector) {
            this.result[this.resultIdx] = vector;
            ++this.resultIdx;
        }

        @Override
        public void visit(TypeDescription type, int posn) {
            if (this.current == null) {
                this.current = this.top[posn];
                this.top = null;
            } else {
                this.current = this.navigate(this.current, posn);
            }
            this.addResult(this.current);
        }

        private ColumnVector navigate(ColumnVector parent, int posn) {
            if (parent instanceof ListColumnVector) {
                return ((ListColumnVector)parent).child;
            }
            if (parent instanceof StructColumnVector) {
                return ((StructColumnVector)parent).fields[posn];
            }
            if (parent instanceof UnionColumnVector) {
                return ((UnionColumnVector)parent).fields[posn];
            }
            if (parent instanceof MapColumnVector) {
                MapColumnVector m = (MapColumnVector)parent;
                return posn == 0 ? m.keys : m.values;
            }
            throw new IllegalArgumentException("Unknown complex column vector " + parent.getClass());
        }
    }

    public static class TypeFinder
    implements TypeVisitor {
        public TypeDescription current;

        public TypeFinder(TypeDescription schema) {
            this.current = schema;
        }

        @Override
        public void visit(TypeDescription type, int posn) {
            this.current = type;
        }
    }

    public static interface TypeVisitor {
        public void visit(TypeDescription var1, int var2);
    }
}

