/*
 * Decompiled with CFR 0.152.
 */
package sdsu.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class NonBlockingInputStream
extends FilterInputStream {
    private int pollDuration;
    private long timeout;

    public NonBlockingInputStream(InputStream inputStream) {
        this(inputStream, 50, Long.MAX_VALUE);
    }

    public NonBlockingInputStream(InputStream inputStream, int n, long l) {
        super(inputStream);
        this.setPollDelay(n);
        this.setTimeout(l);
    }

    private void pollInput() throws IOException {
        long l = System.currentTimeMillis();
        while (this.in.available() <= 0) {
            try {
                if (System.currentTimeMillis() - l >= this.timeout) {
                    throw new InterruptedIOException("Timeout on read after " + this.timeout + " milliseconds");
                }
                Thread.sleep(this.pollDuration);
            }
            catch (InterruptedException interruptedException) {
                throw new InterruptedIOException("read() interrupted");
            }
        }
    }

    public int read() throws IOException, InterruptedIOException {
        this.pollInput();
        return this.in.read();
    }

    public int read(byte[] byArray, int n, int n2) throws IOException, InterruptedIOException {
        this.pollInput();
        int n3 = Math.min(n2, this.in.available());
        return this.in.read(byArray, n, n3);
    }

    public void setPollDelay(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Poll duration must be >= 0. Value is " + n);
        }
        this.pollDuration = n;
    }

    public void setTimeout(long l) throws IllegalArgumentException {
        if (l <= 0L) {
            throw new IllegalArgumentException("Timeout must be > 0. Value is " + l);
        }
        this.timeout = l;
    }
}

