/*
 * Decompiled with CFR 0.152.
 */
package sdsu.net;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import sdsu.io.XorInputStream;
import sdsu.io.XorOutputStream;

public class XorSocket
extends Socket {
    private InputStream in;
    private OutputStream out;
    private byte xorMask = 0;

    public XorSocket(byte by) throws IOException {
        this.xorMask = by;
    }

    public XorSocket(String string, int n, byte by) throws IOException {
        super(string, n);
        this.xorMask = by;
    }

    public XorSocket(String string, int n, InetAddress inetAddress, int n2, byte by) throws IOException {
        super(string, n, inetAddress, n2);
        this.xorMask = by;
    }

    public XorSocket(InetAddress inetAddress, int n, byte by) throws IOException {
        super(inetAddress, n);
        this.xorMask = by;
    }

    public XorSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2, byte by) throws IOException {
        super(inetAddress, n, inetAddress2, n2);
        this.xorMask = by;
    }

    public synchronized void close() throws IOException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.flush();
        super.close();
    }

    public InputStream getInputStream() throws IOException {
        if (this.in == null) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(super.getInputStream());
            this.in = new XorInputStream(bufferedInputStream, this.xorMask);
        }
        return this.in;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.out == null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(super.getOutputStream());
            this.out = new XorOutputStream(bufferedOutputStream, this.xorMask);
        }
        return this.out;
    }
}

