/*
 * Decompiled with CFR 0.152.
 */
package sdsu.util;

public final class CharStack {
    private char[] stackElements;
    private int topStackElement = -1;
    public static final int DEFAULT_QUEUE_SIZE = 256;

    public CharStack() {
        this(256);
    }

    public CharStack(int n) {
        this.stackElements = new char[n];
    }

    public int capacity() {
        return this.stackElements.length;
    }

    public void clear() {
        this.topStackElement = -1;
    }

    private void grow() {
        if (this.capacity() <= 16) {
            this.grow(32);
        } else if (this.capacity() <= 2048) {
            this.grow(this.capacity() * 2);
        } else {
            this.grow((int)((double)this.capacity() * 1.5));
        }
    }

    private void grow(int n) {
        char[] cArray = new char[n];
        System.arraycopy(this.stackElements, 0, cArray, 0, this.capacity());
        this.stackElements = cArray;
    }

    public boolean isEmpty() {
        return this.topStackElement < 0;
    }

    public char peek() {
        return this.stackElements[this.topStackElement];
    }

    public char pop() {
        return this.stackElements[this.topStackElement--];
    }

    public void push(char c) {
        if (this.topStackElement >= this.capacity() - 1) {
            this.grow();
        }
        ++this.topStackElement;
        this.stackElements[this.topStackElement] = c;
    }

    public void push(String string) {
        this.push(string.toCharArray());
    }

    public void push(char[] cArray) {
        int n = 0;
        while (n < cArray.length) {
            this.push(cArray[n]);
            ++n;
        }
    }

    public String toString() {
        return "Stack" + this.capacity() + "[" + String.valueOf(this.stackElements) + "]";
    }
}

