/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.file.keyfunctor;

import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.file.keyfunctor.KeyFunctor;
import org.apache.accumulo.core.file.keyfunctor.RowFunctor;
import org.apache.hadoop.util.bloom.Key;

public class ColumnQualifierFunctor
implements KeyFunctor {
    @Override
    public Key transform(org.apache.accumulo.core.data.Key acuKey) {
        ByteSequence row = acuKey.getRowData();
        ByteSequence cf = acuKey.getColumnFamilyData();
        ByteSequence cq = acuKey.getColumnQualifierData();
        byte[] keyData = new byte[row.length() + cf.length() + cq.length()];
        System.arraycopy(row.getBackingArray(), row.offset(), keyData, 0, row.length());
        System.arraycopy(cf.getBackingArray(), cf.offset(), keyData, row.length(), cf.length());
        System.arraycopy(cq.getBackingArray(), cq.offset(), keyData, row.length() + cf.length(), cq.length());
        return new Key(keyData, 1.0);
    }

    @Override
    public Key transform(Range range) {
        if (RowFunctor.isRangeInBloomFilter(range, PartialKey.ROW_COLFAM_COLQUAL)) {
            return this.transform(range.getStartKey());
        }
        return null;
    }
}

