/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.apache.accumulo.core.client.SampleNotPresentException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.system.MultiIterator;
import org.apache.accumulo.core.metadata.schema.DataFileValue;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.server.fs.FileRef;
import org.apache.accumulo.tserver.FileManager;
import org.apache.hadoop.fs.Path;

public class TabletIteratorEnvironment
implements IteratorEnvironment {
    private final FileManager.ScanFileManager trm;
    private final IteratorUtil.IteratorScope scope;
    private final boolean fullMajorCompaction;
    private final AccumuloConfiguration config;
    private final ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators;
    private Map<FileRef, DataFileValue> files;
    private final Authorizations authorizations;
    private SamplerConfiguration samplerConfig;
    private boolean enableSampleForDeepCopy;

    public TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, AccumuloConfiguration config) {
        if (scope == IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("must set if compaction is full");
        }
        this.scope = scope;
        this.trm = null;
        this.config = config;
        this.fullMajorCompaction = false;
        this.authorizations = Authorizations.EMPTY;
        this.topLevelIterators = new ArrayList();
    }

    private TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, AccumuloConfiguration config, FileManager.ScanFileManager trm, Map<FileRef, DataFileValue> files, Authorizations authorizations, SamplerConfigurationImpl samplerConfig, ArrayList<SortedKeyValueIterator<Key, Value>> topLevelIterators) {
        if (scope == IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("must set if compaction is full");
        }
        this.scope = scope;
        this.trm = trm;
        this.config = config;
        this.fullMajorCompaction = false;
        this.files = files;
        this.authorizations = authorizations;
        if (samplerConfig != null) {
            this.enableSampleForDeepCopy = true;
            this.samplerConfig = samplerConfig.toSamplerConfiguration();
        } else {
            this.enableSampleForDeepCopy = false;
        }
        this.topLevelIterators = topLevelIterators;
    }

    public TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, AccumuloConfiguration config, FileManager.ScanFileManager trm, Map<FileRef, DataFileValue> files, Authorizations authorizations, SamplerConfigurationImpl samplerConfig) {
        this(scope, config, trm, files, authorizations, samplerConfig, new ArrayList<SortedKeyValueIterator<Key, Value>>());
    }

    public TabletIteratorEnvironment(IteratorUtil.IteratorScope scope, boolean fullMajC, AccumuloConfiguration config) {
        if (scope != IteratorUtil.IteratorScope.majc) {
            throw new IllegalArgumentException("Tried to set maj compaction type when scope was " + scope);
        }
        this.scope = scope;
        this.trm = null;
        this.config = config;
        this.fullMajorCompaction = fullMajC;
        this.authorizations = Authorizations.EMPTY;
        this.topLevelIterators = new ArrayList();
    }

    public AccumuloConfiguration getConfig() {
        return this.config;
    }

    public IteratorUtil.IteratorScope getIteratorScope() {
        return this.scope;
    }

    public boolean isFullMajorCompaction() {
        if (this.scope != IteratorUtil.IteratorScope.majc) {
            throw new IllegalStateException("Asked about major compaction type when scope is " + this.scope);
        }
        return this.fullMajorCompaction;
    }

    public SortedKeyValueIterator<Key, Value> reserveMapFileReader(String mapFileName) throws IOException {
        FileRef ref = new FileRef(mapFileName, new Path(mapFileName));
        return (SortedKeyValueIterator)this.trm.openFiles(Collections.singletonMap(ref, this.files.get(ref)), false, null).get(0);
    }

    public void registerSideChannel(SortedKeyValueIterator<Key, Value> iter) {
        this.topLevelIterators.add(iter);
    }

    public Authorizations getAuthorizations() {
        if (this.scope != IteratorUtil.IteratorScope.scan) {
            throw new UnsupportedOperationException("Authorizations may only be supplied when scope is scan but scope is " + this.scope);
        }
        return this.authorizations;
    }

    public SortedKeyValueIterator<Key, Value> getTopLevelIterator(SortedKeyValueIterator<Key, Value> iter) {
        if (this.topLevelIterators.isEmpty()) {
            return iter;
        }
        ArrayList<SortedKeyValueIterator<Key, Value>> allIters = new ArrayList<SortedKeyValueIterator<Key, Value>>(this.topLevelIterators);
        allIters.add(iter);
        return new MultiIterator(allIters, false);
    }

    public boolean isSamplingEnabled() {
        return this.enableSampleForDeepCopy;
    }

    public SamplerConfiguration getSamplerConfiguration() {
        if (this.samplerConfig == null) {
            SamplerConfigurationImpl sci = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)this.config);
            if (sci == null) {
                return null;
            }
            this.samplerConfig = sci.toSamplerConfiguration();
        }
        return this.samplerConfig;
    }

    public IteratorEnvironment cloneWithSamplingEnabled() {
        if (!this.scope.equals((Object)IteratorUtil.IteratorScope.scan)) {
            throw new UnsupportedOperationException();
        }
        SamplerConfigurationImpl sci = SamplerConfigurationImpl.newSamplerConfig((AccumuloConfiguration)this.config);
        if (sci == null) {
            throw new SampleNotPresentException();
        }
        TabletIteratorEnvironment te = new TabletIteratorEnvironment(this.scope, this.config, this.trm, this.files, this.authorizations, sci, this.topLevelIterators);
        return te;
    }
}

