/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.Waiter;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class HBaseCommonTestingUtility {
    protected static final Logger LOG = LoggerFactory.getLogger(HBaseCommonTestingUtility.class);
    public static final List<Object[]> COMPRESSION_ALGORITHMS_PARAMETERIZED = Arrays.asList({Compression.Algorithm.NONE}, {Compression.Algorithm.GZ});
    public static final List<Object[]> BOOLEAN_PARAMETERIZED = Arrays.asList({false}, {true});
    public static final Compression.Algorithm[] COMPRESSION_ALGORITHMS = new Compression.Algorithm[]{Compression.Algorithm.NONE, Compression.Algorithm.GZ};
    protected final Configuration conf;
    public static final String BASE_TEST_DIRECTORY_KEY = "test.build.data.basedirectory";
    public static final String DEFAULT_BASE_TEST_DIRECTORY = "target/test-data";
    private File dataTestDir = null;
    private static final PortAllocator portAllocator = new PortAllocator();

    public HBaseCommonTestingUtility() {
        this(null);
    }

    public HBaseCommonTestingUtility(Configuration conf) {
        this.conf = conf == null ? HBaseConfiguration.create() : conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getDataTestDir() {
        if (this.dataTestDir == null) {
            this.setupDataTestDir();
        }
        return new Path(this.dataTestDir.getAbsolutePath());
    }

    public Path getDataTestDir(String name) {
        return new Path(this.getDataTestDir(), name);
    }

    protected Path setupDataTestDir() {
        if (this.dataTestDir != null) {
            LOG.warn("Data test dir already setup in " + this.dataTestDir.getAbsolutePath());
            return null;
        }
        Path testPath = this.getRandomDir();
        this.dataTestDir = new File(testPath.toString()).getAbsoluteFile();
        System.setProperty("test.build.dir", this.dataTestDir.toString());
        if (this.deleteOnExit()) {
            this.dataTestDir.deleteOnExit();
        }
        this.createSubDir("hbase.local.dir", testPath, "hbase-local-dir");
        return testPath;
    }

    public Path getRandomDir() {
        return new Path(this.getBaseTestDir(), HBaseCommonTestingUtility.getRandomUUID().toString());
    }

    public static UUID getRandomUUID() {
        return new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong());
    }

    protected void createSubDir(String propertyName, Path parent, String subDirName) {
        Path newPath = new Path(parent, subDirName);
        File newDir = new File(newPath.toString()).getAbsoluteFile();
        if (this.deleteOnExit()) {
            newDir.deleteOnExit();
        }
        this.conf.set(propertyName, newDir.getAbsolutePath());
    }

    boolean deleteOnExit() {
        String v = System.getProperty("hbase.testing.preserve.testdir");
        return v == null ? true : !Boolean.parseBoolean(v);
    }

    public boolean cleanupTestDir() {
        if (this.deleteDir(this.dataTestDir)) {
            this.dataTestDir = null;
            return true;
        }
        return false;
    }

    boolean cleanupTestDir(String subdir) {
        if (this.dataTestDir == null) {
            return false;
        }
        return this.deleteDir(new File(this.dataTestDir, subdir));
    }

    private Path getBaseTestDir() {
        String PathName = System.getProperty(BASE_TEST_DIRECTORY_KEY, DEFAULT_BASE_TEST_DIRECTORY);
        return new Path(PathName);
    }

    boolean deleteDir(File dir) {
        if (dir == null || !dir.exists()) {
            return true;
        }
        int ntries = 0;
        do {
            ++ntries;
            try {
                if (this.deleteOnExit()) {
                    FileUtils.deleteDirectory((File)dir);
                }
                return true;
            }
            catch (IOException ex) {
                LOG.warn("Failed to delete " + dir.getAbsolutePath());
            }
            catch (IllegalArgumentException ex) {
                LOG.warn("Failed to delete " + dir.getAbsolutePath(), (Throwable)ex);
            }
        } while (ntries < 30);
        return false;
    }

    public <E extends Exception> long waitFor(long timeout, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor(this.conf, timeout, predicate);
    }

    public <E extends Exception> long waitFor(long timeout, long interval, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor(this.conf, timeout, interval, predicate);
    }

    public <E extends Exception> long waitFor(long timeout, long interval, boolean failIfTimeout, Waiter.Predicate<E> predicate) throws E {
        return Waiter.waitFor(this.conf, timeout, interval, failIfTimeout, predicate);
    }

    public static int randomFreePort() {
        return portAllocator.randomFreePort();
    }

    static class PortAllocator {
        private static final int MIN_RANDOM_PORT = 49152;
        private static final int MAX_RANDOM_PORT = 65534;
        private final Set<Integer> takenRandomPorts = new HashSet<Integer>();
        private final Random random;
        private final AvailablePortChecker portChecker;

        public PortAllocator() {
            this.random = new Random();
            this.portChecker = new AvailablePortChecker(){

                @Override
                public boolean available(int port) {
                    try {
                        ServerSocket sock = new ServerSocket(port);
                        sock.close();
                        return true;
                    }
                    catch (IOException ex) {
                        return false;
                    }
                }
            };
        }

        public PortAllocator(Random random, AvailablePortChecker portChecker) {
            this.random = random;
            this.portChecker = portChecker;
        }

        public PortAllocator(AvailablePortChecker portChecker) {
            this(new Random(), portChecker);
        }

        public int randomFreePort() {
            int port = 0;
            do {
                if (this.takenRandomPorts.contains(port = this.randomPort())) {
                    port = 0;
                    continue;
                }
                this.takenRandomPorts.add(port);
                if (this.portChecker.available(port)) continue;
                port = 0;
            } while (port == 0);
            return port;
        }

        private int randomPort() {
            return 49152 + this.random.nextInt(16382);
        }

        static interface AvailablePortChecker {
            public boolean available(int var1);
        }
    }
}

