/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class HealthTracker$
implements Logging {
    public static HealthTracker$ MODULE$;
    private final String DEFAULT_TIMEOUT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new HealthTracker$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Clock $lessinit$greater$default$4() {
        return new SystemClock();
    }

    private String DEFAULT_TIMEOUT() {
        return this.DEFAULT_TIMEOUT;
    }

    public boolean isExcludeOnFailureEnabled(SparkConf conf) {
        Option option = (Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED());
        if (option instanceof Some) {
            Some some = (Some)option;
            boolean enabled = BoxesRunTime.unboxToBoolean((Object)some.value());
            return enabled;
        }
        if (None$.MODULE$.equals(option)) {
            String legacyKey = package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key();
            return ((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).exists((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)legacyTimeout -> {
                if (legacyTimeout == 0L) {
                    MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(63).append("Turning off excludeOnFailure due to legacy configuration: ").append(legacyKey).append(" == 0").toString());
                    return false;
                }
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Turning on excludeOnFailure due to legacy configuration: ").append(legacyKey).append(" > 0").toString());
                return true;
            });
        }
        throw new MatchError((Object)option);
    }

    public long getExludeOnFailureTimeout(SparkConf conf) {
        return BoxesRunTime.unboxToLong((Object)((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> Utils$.MODULE$.timeStringAsMs(MODULE$.DEFAULT_TIMEOUT())))));
    }

    public void validateExcludeOnFailureConfs(SparkConf conf) {
        ((IterableLike)new .colon.colon(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_EXECUTOR(), (List)new .colon.colon(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILURES_PER_EXEC_STAGE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE_STAGE(), (List)new .colon.colon(package$.MODULE$.MAX_FAILURES_PER_EXEC(), (List)new .colon.colon(package$.MODULE$.MAX_FAILED_EXEC_PER_NODE(), (List)Nil$.MODULE$))))))).foreach((Function1 & Serializable & scala.Serializable)config -> {
            HealthTracker$.$anonfun$validateExcludeOnFailureConfs$1(conf, config);
            return BoxedUnit.UNIT;
        });
        long timeout = this.getExludeOnFailureTimeout(conf);
        if (timeout <= 0L) {
            Option option = (Option)conf.get(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF());
            if (option instanceof Some) {
                HealthTracker$.mustBePos$1(package$.MODULE$.EXCLUDE_ON_FAILURE_TIMEOUT_CONF().key(), Long.toString(timeout));
            } else if (None$.MODULE$.equals(option)) {
                HealthTracker$.mustBePos$1(package$.MODULE$.EXCLUDE_ON_FAILURE_LEGACY_TIMEOUT_CONF().key(), Long.toString(timeout));
            } else {
                throw new MatchError((Object)option);
            }
        }
        int maxTaskFailures = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.TASK_MAX_FAILURES()));
        int maxNodeAttempts = BoxesRunTime.unboxToInt((Object)conf.get(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE()));
        if (maxNodeAttempts >= maxTaskFailures) {
            throw new IllegalArgumentException(new StringBuilder(181).append(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key()).append(" ").append("( = ").append(maxNodeAttempts).append(") was >= ").append(package$.MODULE$.TASK_MAX_FAILURES().key()).append(" ").append("( = ").append(maxTaskFailures).append(" ). Though excludeOnFailure is enabled, with this configuration, ").append("Spark will not be robust to one bad node. Decrease ").append(package$.MODULE$.MAX_TASK_ATTEMPTS_PER_NODE().key()).append(", increase ").append(package$.MODULE$.TASK_MAX_FAILURES().key()).append(", ").append("or disable excludeOnFailure with ").append(package$.MODULE$.EXCLUDE_ON_FAILURE_ENABLED().key()).toString());
        }
    }

    private static final void mustBePos$1(String k, String v) {
        throw new IllegalArgumentException(new StringBuilder(23).append(k).append(" was ").append(v).append(", but must be > 0.").toString());
    }

    public static final /* synthetic */ void $anonfun$validateExcludeOnFailureConfs$1(SparkConf conf$2, ConfigEntry config) {
        int v = BoxesRunTime.unboxToInt(conf$2.get(config));
        if (v <= 0) {
            HealthTracker$.mustBePos$1(config.key(), Integer.toString(v));
            return;
        }
    }

    private HealthTracker$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.DEFAULT_TIMEOUT = "1h";
    }
}

