/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.ppr;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.metastore.FileFormatProxy;
import org.apache.hadoop.hive.metastore.PartitionExpressionProxy;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.FileMetadataExprType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.io.orc.OrcFileFormatProxy;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.io.sarg.ConvertAstToSearchArg;
import org.apache.hadoop.hive.ql.io.sarg.SearchArgument;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.optimizer.ppr.PartitionPruner;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionExpressionForMetastore
implements PartitionExpressionProxy {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionExpressionForMetastore.class);

    public String convertExprToFilter(byte[] exprBytes) throws MetaException {
        return this.deserializeExpr(exprBytes).getExprString();
    }

    public boolean filterPartitionsByExpr(List<FieldSchema> partColumns, byte[] exprBytes, String defaultPartitionName, List<String> partitionNames) throws MetaException {
        ArrayList<String> partColumnNames = new ArrayList<String>();
        ArrayList<PrimitiveTypeInfo> partColumnTypeInfos = new ArrayList<PrimitiveTypeInfo>();
        for (FieldSchema fs : partColumns) {
            partColumnNames.add(fs.getName());
            partColumnTypeInfos.add(TypeInfoFactory.getPrimitiveTypeInfo((String)fs.getType()));
        }
        ExprNodeGenericFuncDesc expr = this.deserializeExpr(exprBytes);
        try {
            ExprNodeDescUtils.replaceEqualDefaultPartition(expr, defaultPartitionName);
        }
        catch (SemanticException ex) {
            LOG.error("Failed to replace default partition", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
        try {
            long startTime = System.nanoTime();
            long len = partitionNames.size();
            boolean result = PartitionPruner.prunePartitionNames(partColumnNames, partColumnTypeInfos, expr, defaultPartitionName, partitionNames);
            double timeMs = (double)(System.nanoTime() - startTime) / 1000000.0;
            LOG.debug("Pruning " + len + " partition names took " + timeMs + "ms");
            return result;
        }
        catch (HiveException ex) {
            LOG.error("Failed to apply the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
    }

    private ExprNodeGenericFuncDesc deserializeExpr(byte[] exprBytes) throws MetaException {
        ExprNodeGenericFuncDesc expr = null;
        try {
            expr = SerializationUtilities.deserializeExpressionFromKryo(exprBytes);
        }
        catch (Exception ex) {
            LOG.error("Failed to deserialize the expression", (Throwable)ex);
            throw new MetaException(ex.getMessage());
        }
        if (expr == null) {
            throw new MetaException("Failed to deserialize expression - ExprNodeDesc not present");
        }
        return expr;
    }

    public FileFormatProxy getFileFormatProxy(FileMetadataExprType type) {
        switch (type) {
            case ORC_SARG: {
                return new OrcFileFormatProxy();
            }
        }
        throw new RuntimeException("Unsupported format " + type);
    }

    public FileMetadataExprType getMetadataType(String inputFormat) {
        try {
            Class<?> ifClass = Class.forName(inputFormat);
            if (OrcInputFormat.class.isAssignableFrom(ifClass)) {
                return FileMetadataExprType.ORC_SARG;
            }
            return null;
        }
        catch (Throwable t) {
            LOG.warn("Can't create the class for input format " + inputFormat, t);
            return null;
        }
    }

    public SearchArgument createSarg(byte[] expr) {
        return ConvertAstToSearchArg.create(expr);
    }
}

