/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse.repl.dump.events;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.NotificationEvent;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.EximUtil;
import org.apache.hadoop.hive.ql.parse.repl.DumpType;
import org.apache.hadoop.hive.ql.parse.repl.dump.Utils;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.AbstractEventHandler;
import org.apache.hadoop.hive.ql.parse.repl.dump.events.EventHandler;
import org.apache.hadoop.hive.ql.parse.repl.load.DumpMetaData;

class InsertHandler
extends AbstractEventHandler {
    InsertHandler(NotificationEvent event) {
        super(event);
    }

    @Override
    public void handle(EventHandler.Context withinContext) throws Exception {
        if (withinContext.hiveConf.getBoolVar(HiveConf.ConfVars.REPL_DUMP_METADATA_ONLY)) {
            return;
        }
        InsertMessage insertMsg = this.deserializer.getInsertMessage(this.event.getMessage());
        Table qlMdTable = this.tableObject(insertMsg);
        if (!Utils.shouldReplicate(withinContext.replicationSpec, qlMdTable, withinContext.hiveConf).booleanValue()) {
            return;
        }
        List<Partition> qlPtns = null;
        if (qlMdTable.isPartitioned() && null != insertMsg.getPtnObj()) {
            qlPtns = Collections.singletonList(this.partitionObject(qlMdTable, insertMsg));
        }
        Path metaDataPath = new Path(withinContext.eventRoot, "_metadata");
        withinContext.replicationSpec.setIsReplace(insertMsg.isReplace());
        EximUtil.createExportDump(metaDataPath.getFileSystem((Configuration)withinContext.hiveConf), metaDataPath, qlMdTable, qlPtns, withinContext.replicationSpec, withinContext.hiveConf);
        Iterable files = insertMsg.getFiles();
        if (files != null) {
            Path dataPath;
            if (null == qlPtns || qlPtns.isEmpty()) {
                dataPath = new Path(withinContext.eventRoot, "data");
            } else {
                assert (1 == qlPtns.size());
                dataPath = new Path(withinContext.eventRoot, qlPtns.get(0).getName());
            }
            try (BufferedWriter fileListWriter = this.writer(withinContext, dataPath);){
                for (String file : files) {
                    fileListWriter.write(file + "\n");
                }
            }
        }
        LOG.info("Processing#{} INSERT message : {}", (Object)this.fromEventId(), (Object)this.event.getMessage());
        DumpMetaData dmd = withinContext.createDmd(this);
        dmd.setPayload(this.event.getMessage());
        dmd.write();
    }

    private Table tableObject(InsertMessage insertMsg) throws Exception {
        return new Table(insertMsg.getTableObj());
    }

    private Partition partitionObject(Table qlMdTable, InsertMessage insertMsg) throws Exception {
        return new Partition(qlMdTable, insertMsg.getPtnObj());
    }

    private BufferedWriter writer(EventHandler.Context withinContext, Path dataPath) throws IOException {
        Path filesPath = new Path(dataPath, "_files");
        FileSystem fs = dataPath.getFileSystem((Configuration)withinContext.hiveConf);
        return new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(filesPath)));
    }

    @Override
    public DumpType dumpType() {
        return DumpType.EVENT_INSERT;
    }
}

