/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.SetPartitionsStatsRequest;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.FetchOperator;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.stats.ColumnStatisticsObjTranslator;
import org.apache.hadoop.hive.ql.stats.IStatsProcessor;
import org.apache.hadoop.hive.serde2.objectinspector.InspectableObject;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColStatsProcessor
implements IStatsProcessor {
    private static final transient Logger LOG = LoggerFactory.getLogger(ColStatsProcessor.class);
    private FetchOperator ftOp;
    private FetchWork fWork;
    private ColumnStatsDesc colStatDesc;
    private HiveConf conf;
    private boolean isStatsReliable;

    public ColStatsProcessor(ColumnStatsDesc colStats, HiveConf conf) {
        this.conf = conf;
        this.fWork = colStats.getFWork();
        this.colStatDesc = colStats;
        this.isStatsReliable = conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_RELIABLE);
    }

    @Override
    public void initialize(CompilationOpContext opContext) {
        try {
            this.fWork.initializeForFetch(opContext);
            JobConf job = new JobConf((Configuration)this.conf);
            this.ftOp = new FetchOperator(this.fWork, job);
        }
        catch (Exception e) {
            LOG.error(StringUtils.stringifyException((Throwable)e));
            throw new RuntimeException(e);
        }
    }

    @Override
    public int process(Hive db, Table tbl) throws Exception {
        return this.persistColumnStats(db, tbl);
    }

    private List<ColumnStatistics> constructColumnStatsFromPackedRows(Table tbl1) throws HiveException, MetaException, IOException {
        InspectableObject packedRow;
        Table tbl = tbl1;
        String partName = null;
        List<String> colName = this.colStatDesc.getColName();
        List<String> colType = this.colStatDesc.getColType();
        boolean isTblLevel = this.colStatDesc.isTblLevel();
        ArrayList<ColumnStatistics> stats = new ArrayList<ColumnStatistics>();
        while ((packedRow = this.ftOp.getNextRow()) != null) {
            int numOfStatCols;
            if (packedRow.oi.getCategory() != ObjectInspector.Category.STRUCT) {
                throw new HiveException("Unexpected object type encountered while unpacking row");
            }
            ArrayList<ColumnStatisticsObj> statsObjs = new ArrayList<ColumnStatisticsObj>();
            StructObjectInspector soi = (StructObjectInspector)packedRow.oi;
            List fields = soi.getAllStructFieldRefs();
            List list = soi.getStructFieldsDataAsList(packedRow.o);
            List<FieldSchema> partColSchema = tbl.getPartCols();
            int n = numOfStatCols = isTblLevel ? fields.size() : fields.size() - partColSchema.size();
            assert (list != null);
            for (int i = 0; i < numOfStatCols; ++i) {
                StructField structField = (StructField)fields.get(i);
                String columnName = colName.get(i);
                String columnType = colType.get(i);
                Object values = list.get(i);
                try {
                    ColumnStatisticsObj statObj = ColumnStatisticsObjTranslator.readHiveStruct(columnName, columnType, structField, values);
                    statsObjs.add(statObj);
                    continue;
                }
                catch (Exception e) {
                    if (this.isStatsReliable) {
                        throw new HiveException("Statistics collection failed while (hive.stats.reliable)", e);
                    }
                    LOG.debug("Because {} is infinite or NaN, we skip stats.", (Object)columnName, (Object)e);
                }
            }
            if (statsObjs.isEmpty()) continue;
            if (!isTblLevel) {
                ArrayList<String> partVals = new ArrayList<String>();
                for (int i = fields.size() - partColSchema.size(); i < fields.size(); ++i) {
                    Object partVal = ((PrimitiveObjectInspector)((StructField)fields.get(i)).getFieldObjectInspector()).getPrimitiveJavaObject(list.get(i));
                    partVals.add(partVal == null ? this.conf.getVar(HiveConf.ConfVars.DEFAULTPARTITIONNAME) : partVal.toString());
                }
                partName = Warehouse.makePartName(partColSchema, partVals);
            }
            ColumnStatisticsDesc statsDesc = this.buildColumnStatsDesc(tbl, partName, isTblLevel);
            ColumnStatistics colStats = new ColumnStatistics();
            colStats.setStatsDesc(statsDesc);
            colStats.setStatsObj(statsObjs);
            stats.add(colStats);
        }
        this.ftOp.clearFetchContext();
        return stats;
    }

    private ColumnStatisticsDesc buildColumnStatsDesc(Table table, String partName, boolean isTblLevel) {
        String dbName = table.getDbName();
        assert (dbName != null);
        ColumnStatisticsDesc statsDesc = new ColumnStatisticsDesc();
        statsDesc.setDbName(dbName);
        statsDesc.setTableName(table.getTableName());
        statsDesc.setIsTblLevel(isTblLevel);
        if (!isTblLevel) {
            statsDesc.setPartName(partName);
        } else {
            statsDesc.setPartName(null);
        }
        return statsDesc;
    }

    public int persistColumnStats(Hive db, Table tbl) throws HiveException, MetaException, IOException {
        List<ColumnStatistics> colStats = this.constructColumnStatsFromPackedRows(tbl);
        if (colStats.isEmpty()) {
            return 0;
        }
        SetPartitionsStatsRequest request = new SetPartitionsStatsRequest(colStats);
        request.setNeedMerge(this.colStatDesc.isNeedMerge());
        db.setPartitionColumnStatistics(request);
        return 0;
    }

    @Override
    public void setDpPartSpecs(Collection<Partition> dpPartSpecs) {
    }
}

