/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformer;
import org.apache.hadoop.hive.ql.udf.generic.AbstractTransformerAdapter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;

class DateTransformerAdapter
extends AbstractTransformerAdapter {
    final DateObjectInspector columnType;
    final DateWritableV2 writable;

    public DateTransformerAdapter(DateObjectInspector columnType, AbstractTransformer transformer) {
        this(columnType, transformer, new DateWritableV2());
    }

    public DateTransformerAdapter(DateObjectInspector columnType, AbstractTransformer transformer, DateWritableV2 writable) {
        super(transformer);
        this.columnType = columnType;
        this.writable = writable;
    }

    @Override
    public Object getTransformedWritable(GenericUDF.DeferredObject object) throws HiveException {
        Date transformedValue;
        Date value = this.columnType.getPrimitiveJavaObject(object.get());
        if (value != null && (transformedValue = this.transformer.transform(value)) != null) {
            this.writable.set(transformedValue);
            return this.writable;
        }
        return null;
    }
}

