/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.UnsupportedFileSystemException;
import org.apache.hadoop.fs.permission.FsPermission;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileContext {
    private static final Logger LOG = LoggerFactory.getLogger(TestFileContext.class);

    @Test
    public void testDefaultURIWithoutScheme() throws Exception {
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "/");
        try {
            FileContext.getFileContext((Configuration)conf);
            Assert.fail((String)(UnsupportedFileSystemException.class + " not thrown!"));
        }
        catch (UnsupportedFileSystemException ufse) {
            LOG.info("Expected exception: ", (Throwable)ufse);
        }
    }

    @Test
    public void testConfBasedAndAPIBasedSetUMask() throws Exception {
        Configuration conf = new Configuration();
        String defaultlUMask = conf.get("fs.permissions.umask-mode");
        Assert.assertEquals((String)"Default UMask changed!", (Object)"022", (Object)defaultlUMask);
        URI uri1 = new URI("file://mydfs:50070/");
        URI uri2 = new URI("file://tmp");
        FileContext fc1 = FileContext.getFileContext((URI)uri1, (Configuration)conf);
        FileContext fc2 = FileContext.getFileContext((URI)uri2, (Configuration)conf);
        Assert.assertEquals((String)"Umask for fc1 is incorrect", (long)18L, (long)fc1.getUMask().toShort());
        Assert.assertEquals((String)"Umask for fc2 is incorrect", (long)18L, (long)fc2.getUMask().toShort());
        conf.set("fs.permissions.umask-mode", "011");
        Assert.assertEquals((String)"Umask for fc1 is incorrect", (long)9L, (long)fc1.getUMask().toShort());
        Assert.assertEquals((String)"Umask for fc2 is incorrect", (long)9L, (long)fc2.getUMask().toShort());
        conf.set("fs.permissions.umask-mode", "066");
        fc1.setUMask(FsPermission.createImmutable((short)27));
        Assert.assertEquals((String)"Umask for fc1 is incorrect", (long)27L, (long)fc1.getUMask().toShort());
        Assert.assertEquals((String)"Umask for fc2 is incorrect", (long)54L, (long)fc2.getUMask().toShort());
        conf.set("fs.permissions.umask-mode", "077");
        fc2.setUMask(FsPermission.createImmutable((short)36));
        Assert.assertEquals((String)"Umask for fc1 is incorrect", (long)27L, (long)fc1.getUMask().toShort());
        Assert.assertEquals((String)"Umask for fc2 is incorrect", (long)36L, (long)fc2.getUMask().toShort());
    }
}

