/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestFsUrlConnectionPath {
    private static final String CURRENT = Paths.get("", new String[0]).toAbsolutePath().toString();
    private static final String ABSOLUTE_PATH = "file:" + CURRENT + "/abs.txt";
    private static final String RELATIVE_PATH = "file:relative.txt";
    private static final String ABSOLUTE_PATH_W_SPACE = "file:" + CURRENT + "/abs 1.txt";
    private static final String RELATIVE_PATH_W_SPACE = "file:relative 1.txt";
    private static final String ABSOLUTE_PATH_W_ENCODED_SPACE = "file:" + CURRENT + "/abs%201.txt";
    private static final String RELATIVE_PATH_W_ENCODED_SPACE = "file:relative%201.txt";
    private static final String DATA = "data";
    private static final Configuration CONFIGURATION = new Configuration();

    @BeforeClass
    public static void initialize() throws IOException {
        TestFsUrlConnectionPath.write(ABSOLUTE_PATH.substring(5), DATA);
        TestFsUrlConnectionPath.write(RELATIVE_PATH.substring(5), DATA);
        TestFsUrlConnectionPath.write(ABSOLUTE_PATH_W_SPACE.substring(5), DATA);
        TestFsUrlConnectionPath.write(RELATIVE_PATH_W_SPACE.substring(5), DATA);
        URL.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
    }

    @AfterClass
    public static void cleanup() {
        TestFsUrlConnectionPath.delete(ABSOLUTE_PATH.substring(5));
        TestFsUrlConnectionPath.delete(RELATIVE_PATH.substring(5));
        TestFsUrlConnectionPath.delete(ABSOLUTE_PATH_W_SPACE.substring(5));
        TestFsUrlConnectionPath.delete(RELATIVE_PATH_W_SPACE.substring(5));
    }

    public static void delete(String path) {
        File file = new File(path);
        file.delete();
    }

    public static void write(String path, String data) throws IOException {
        File file = new File(path);
        file.createNewFile();
        FileWriter fw = new FileWriter(file);
        fw.write(data);
        fw.close();
    }

    public static int readStream(String path) throws Exception {
        URL url = new URL(path);
        InputStream is = url.openStream();
        return is.available();
    }

    @Test
    public void testAbsolutePath() throws Exception {
        int length = TestFsUrlConnectionPath.readStream(ABSOLUTE_PATH);
        Assert.assertTrue((length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRelativePath() throws Exception {
        int length = TestFsUrlConnectionPath.readStream(RELATIVE_PATH);
        Assert.assertTrue((length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testAbsolutePathWithSpace() throws Exception {
        int length = TestFsUrlConnectionPath.readStream(ABSOLUTE_PATH_W_ENCODED_SPACE);
        Assert.assertTrue((length > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testRelativePathWithSpace() throws Exception {
        int length = TestFsUrlConnectionPath.readStream(RELATIVE_PATH_W_ENCODED_SPACE);
        Assert.assertTrue((length > 1 ? 1 : 0) != 0);
    }
}

