/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.io.WeakReferencedElasticByteBufferPool;
import org.apache.hadoop.test.HadoopTestBase;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractByteAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestWeakReferencedElasticByteBufferPool
extends HadoopTestBase {
    private final boolean isDirect;
    private final String type;

    @Parameterized.Parameters(name="Buffer type : {0}")
    public static List<String> params() {
        return Arrays.asList("direct", "array");
    }

    public TestWeakReferencedElasticByteBufferPool(String type) {
        this.type = type;
        this.isDirect = !"array".equals(type);
    }

    @Test
    public void testGetAndPutBasic() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        int bufferSize = 5;
        ByteBuffer buffer = pool.getBuffer(this.isDirect, bufferSize);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)buffer.isDirect()).describedAs("Buffered returned should be of correct type {}", new Object[]{this.type})).isEqualTo(this.isDirect);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.capacity()).describedAs("Initial capacity of returned buffer from pool", new Object[0])).isEqualTo(bufferSize);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).describedAs("Initial position of returned buffer from pool", new Object[0])).isEqualTo(0);
        byte[] arr = this.createByteArray(bufferSize);
        buffer.put(arr, 0, arr.length);
        buffer.flip();
        this.validateBufferContent(buffer, arr);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).describedAs("Buffer's position after filling bytes in it", new Object[0])).isEqualTo(bufferSize);
        pool.putBuffer(buffer);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer.position()).describedAs("Position should be reset to 0 after returning buffer to the pool", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testPoolingWithDifferentSizes() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer = pool.getBuffer(this.isDirect, 5);
        ByteBuffer buffer1 = pool.getBuffer(this.isDirect, 10);
        ByteBuffer buffer2 = pool.getBuffer(this.isDirect, 15);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(0);
        pool.putBuffer(buffer1);
        pool.putBuffer(buffer2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(2);
        ByteBuffer buffer3 = pool.getBuffer(this.isDirect, 12);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer3.capacity()).describedAs("Pooled buffer should have older capacity", new Object[0])).isEqualTo(15);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(1);
        pool.putBuffer(buffer);
        ByteBuffer buffer4 = pool.getBuffer(this.isDirect, 6);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer4.capacity()).describedAs("Pooled buffer should have older capacity", new Object[0])).isEqualTo(10);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(1);
        pool.release();
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool post release", new Object[0])).isEqualTo(0);
    }

    @Test
    public void testPoolingWithDifferentInsertionTime() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer = pool.getBuffer(this.isDirect, 10);
        ByteBuffer buffer1 = pool.getBuffer(this.isDirect, 10);
        ByteBuffer buffer2 = pool.getBuffer(this.isDirect, 10);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(0);
        pool.putBuffer(buffer1);
        pool.putBuffer(buffer2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(2);
        ByteBuffer buffer3 = pool.getBuffer(this.isDirect, 10);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer3).describedAs("Buffers should be returned in order of their insertion time", new Object[0])).isSameAs((Object)buffer1);
        pool.putBuffer(buffer);
        ByteBuffer buffer4 = pool.getBuffer(this.isDirect, 10);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)buffer4).describedAs("Buffers should be returned in order of their insertion time", new Object[0])).isSameAs((Object)buffer2);
    }

    @Test
    public void testGarbageCollection() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer = pool.getBuffer(this.isDirect, 5);
        ByteBuffer buffer1 = pool.getBuffer(this.isDirect, 10);
        ByteBuffer buffer2 = pool.getBuffer(this.isDirect, 15);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(0);
        pool.putBuffer(buffer1);
        pool.putBuffer(buffer2);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(2);
        ByteBuffer buffer4 = pool.getBuffer(this.isDirect, 12);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer4.capacity()).describedAs("Pooled buffer should have older capacity", new Object[0])).isEqualTo(15);
        pool.putBuffer(buffer4);
        buffer1 = null;
        buffer2 = null;
        buffer4 = null;
        System.gc();
        ByteBuffer buffer3 = pool.getBuffer(this.isDirect, 12);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer3.capacity()).describedAs("After garbage collection new buffer should be returned with fixed capacity", new Object[0])).isEqualTo(12);
    }

    @Test
    public void testWeakReferencesPruning() {
        WeakReferencedElasticByteBufferPool pool = new WeakReferencedElasticByteBufferPool();
        ByteBuffer buffer1 = pool.getBuffer(this.isDirect, 5);
        ByteBuffer buffer2 = pool.getBuffer(this.isDirect, 10);
        ByteBuffer buffer3 = pool.getBuffer(this.isDirect, 15);
        pool.putBuffer(buffer2);
        pool.putBuffer(buffer3);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(2);
        buffer2 = null;
        System.gc();
        ByteBuffer buffer4 = pool.getBuffer(this.isDirect, 10);
        ((AbstractIntegerAssert)Assertions.assertThat((int)pool.getCurrentBuffersCount(this.isDirect)).describedAs("Number of buffers in the pool", new Object[0])).isEqualTo(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)buffer4.capacity()).describedAs("After gc, pool should return next greater than available buffer", new Object[0])).isEqualTo(15);
    }

    private void validateBufferContent(ByteBuffer buffer, byte[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            ((AbstractByteAssert)Assertions.assertThat((byte)buffer.get()).describedAs("Content of buffer at index {} should match with content of byte array", new Object[]{i})).isEqualTo(arr[i]);
        }
    }

    private byte[] createByteArray(int length) {
        byte[] arr = new byte[length];
        Random r = new Random();
        r.nextBytes(arr);
        return arr;
    }
}

