/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;
import org.mockito.Mockito;

public class TestDefaultImpersonationProvider {
    private String proxyUser;
    private String user;
    private DefaultImpersonationProvider provider;
    private UserGroupInformation userGroupInformation = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
    private UserGroupInformation realUserUGI = (UserGroupInformation)Mockito.mock(UserGroupInformation.class);
    private Configuration conf;
    @Rule
    public Timeout globalTimeout = new Timeout(10000);

    @Before
    public void setup() {
        this.conf = new Configuration();
        this.provider = new DefaultImpersonationProvider();
        this.conf.set("hadoop.proxyuser.fakeuser.groups", "*");
        this.conf.set("hadoop.proxyuser.fakeuser.hosts", "*");
        this.conf.set("hadoop.proxyuser.test.user.groups", "*");
        this.conf.set("hadoop.proxyuser.test.user.hosts", "*");
        this.conf.set("hadoop.proxyuser.test user2.groups", "*");
        this.conf.set("hadoop.proxyuser.test user2.hosts", "*");
        this.provider.setConf(this.conf);
        this.provider.init("hadoop.proxyuser");
    }

    @Test
    public void testAuthorizationSuccess() throws AuthorizationException {
        this.proxyUser = "fakeuser";
        this.user = "dummyUser";
        Mockito.when((Object)this.realUserUGI.getShortUserName()).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.userGroupInformation.getRealUser()).thenReturn((Object)this.realUserUGI);
        this.provider.authorize(this.userGroupInformation, "2.2.2.2");
        this.user = "somerandomuser";
        this.proxyUser = "test.user";
        Mockito.when((Object)this.realUserUGI.getShortUserName()).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.userGroupInformation.getRealUser()).thenReturn((Object)this.realUserUGI);
        this.provider.authorize(this.userGroupInformation, "2.2.2.2");
    }

    @Test
    public void testAuthorizationFailure() throws Exception {
        this.user = "dummyUser";
        this.proxyUser = "test user2";
        Mockito.when((Object)this.realUserUGI.getShortUserName()).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.realUserUGI.getUserName()).thenReturn((Object)this.proxyUser);
        Mockito.when((Object)this.userGroupInformation.getUserName()).thenReturn((Object)this.user);
        Mockito.when((Object)this.userGroupInformation.getRealUser()).thenReturn((Object)this.realUserUGI);
        LambdaTestUtils.intercept(AuthorizationException.class, "User: " + this.proxyUser + " is not allowed to impersonate " + this.user, () -> this.provider.authorize(this.userGroupInformation, "2.2.2.2"));
    }

    @After
    public void clear() {
        this.provider = null;
        this.conf = null;
        this.userGroupInformation = null;
        this.realUserUGI = null;
    }
}

