/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.fetch;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.pig.StoreFuncInterface;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigOutputFormat;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStoreImpl;
import org.apache.pig.backend.hadoop.executionengine.shims.HadoopShims;
import org.apache.pig.impl.PigContext;

public class FetchPOStoreImpl
extends POStoreImpl {
    private PigContext pc;
    private RecordWriter<?, ?> writer;
    private TaskAttemptContext context;
    private OutputCommitter outputCommitter;

    public FetchPOStoreImpl(PigContext pc) {
        this.pc = pc;
    }

    @Override
    public StoreFuncInterface createStoreFunc(POStore store) throws IOException {
        Configuration conf = ConfigurationUtil.toConfiguration(this.pc.getProperties());
        StoreFuncInterface storeFunc = store.getStoreFunc();
        JobContext jc = HadoopShims.createJobContext(conf, new JobID());
        OutputFormat outputFormat = storeFunc.getOutputFormat();
        PigOutputFormat.setLocation(jc, store);
        this.context = HadoopShims.createTaskAttemptContext(conf, HadoopShims.getNewTaskAttemptID());
        PigOutputFormat.setLocation((JobContext)this.context, store);
        try {
            outputFormat.checkOutputSpecs(jc);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        try {
            this.outputCommitter = outputFormat.getOutputCommitter(this.context);
            this.outputCommitter.setupJob(jc);
            this.outputCommitter.setupTask(this.context);
            this.writer = outputFormat.getRecordWriter(this.context);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        storeFunc.prepareToWrite(this.writer);
        return storeFunc;
    }

    @Override
    public void tearDown() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = null;
        }
        if (this.outputCommitter.needsTaskCommit(this.context)) {
            this.outputCommitter.commitTask(this.context);
        }
        this.outputCommitter.commitJob((JobContext)this.context);
    }

    @Override
    public void cleanUp() throws IOException {
        if (this.writer != null) {
            try {
                this.writer.close(this.context);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.writer = null;
        }
        this.outputCommitter.commitJob((JobContext)this.context);
    }
}

