/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.data.Tuple;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;

public class SparkPigContext {
    private static SparkPigContext context = null;
    private static ThreadLocal<Integer> defaultParallelism = null;
    private static ConcurrentHashMap<String, Broadcast<List<Tuple>>> broadcastedVars = new ConcurrentHashMap();

    public static SparkPigContext get() {
        if (context == null) {
            context = new SparkPigContext();
        }
        return context;
    }

    public static int getDefaultParallelism() {
        return defaultParallelism.get();
    }

    public static int getParallelism(List<RDD<Tuple>> predecessors, PhysicalOperator physicalOperator) {
        if (defaultParallelism != null) {
            return SparkPigContext.getDefaultParallelism();
        }
        int parallelism = physicalOperator.getRequestedParallelism();
        if (parallelism <= 0) {
            int maxParallism = 0;
            for (int i = 0; i < predecessors.size(); ++i) {
                int tmpParallelism = predecessors.get(i).getNumPartitions();
                if (tmpParallelism <= maxParallism) continue;
                maxParallism = tmpParallelism;
            }
            parallelism = maxParallism;
        }
        return parallelism;
    }

    public static void setDefaultParallelism(int defaultParallelism) {
        SparkPigContext.defaultParallelism.set(defaultParallelism);
    }

    public static ConcurrentHashMap<String, Broadcast<List<Tuple>>> getBroadcastedVars() {
        return broadcastedVars;
    }
}

