/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.exceptions.ClientExceptionsUtil;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.ipc.IPCUtil;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hbase.thirdparty.io.netty.channel.DefaultEventLoop;
import org.apache.hbase.thirdparty.io.netty.channel.EventLoop;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={ClientTests.class, SmallTests.class})
public class TestIPCUtil {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestIPCUtil.class);

    private static Throwable create(Class<? extends Throwable> clazz) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            Constructor<? extends Throwable> c = clazz.getDeclaredConstructor(new Class[0]);
            c.setAccessible(true);
            return c.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException c) {
            try {
                Constructor<? extends Throwable> c2 = clazz.getDeclaredConstructor(String.class);
                c2.setAccessible(true);
                return c2.newInstance("error");
            }
            catch (NoSuchMethodException c2) {
                try {
                    Constructor<? extends Throwable> c3 = clazz.getDeclaredConstructor(Throwable.class);
                    c3.setAccessible(true);
                    return c3.newInstance(new Exception("error"));
                }
                catch (NoSuchMethodException c3) {
                    try {
                        Constructor<? extends Throwable> c4 = clazz.getDeclaredConstructor(String.class, Throwable.class);
                        c4.setAccessible(true);
                        return c4.newInstance("error", new Exception("error"));
                    }
                    catch (NoSuchMethodException c4) {
                        Constructor<? extends Throwable> c5 = clazz.getDeclaredConstructor(Throwable.class, Throwable.class);
                        c5.setAccessible(true);
                        return c5.newInstance(new Exception("error"), "error");
                    }
                }
            }
        }
    }

    @Test
    public void testWrapConnectionException() throws Exception {
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
        for (Class clazz : ClientExceptionsUtil.getConnectionExceptionTypes()) {
            exceptions.add(TestIPCUtil.create(clazz));
        }
        InetSocketAddress addr = InetSocketAddress.createUnresolved("127.0.0.1", 12345);
        for (Throwable exception : exceptions) {
            if (exception instanceof TimeoutException) {
                MatcherAssert.assertThat((Object)IPCUtil.wrapException((InetSocketAddress)addr, null, (Throwable)exception), (Matcher)CoreMatchers.instanceOf(TimeoutIOException.class));
                continue;
            }
            IOException ioe = IPCUtil.wrapException((InetSocketAddress)addr, (RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO, (Throwable)exception);
            if (ioe.getMessage() != null) {
                Assert.assertTrue((boolean)ioe.getMessage().contains(RegionInfoBuilder.FIRST_META_REGIONINFO.getRegionNameAsString()));
            }
            MatcherAssert.assertThat((Object)ioe, (Matcher)CoreMatchers.instanceOf(exception.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecute() throws IOException {
        DefaultEventLoop eventLoop = new DefaultEventLoop();
        final MutableInt executed = new MutableInt(0);
        final MutableInt numStackTraceElements = new MutableInt(0);
        final CompletableFuture future = new CompletableFuture();
        try {
            IPCUtil.execute((EventLoop)eventLoop, (Runnable)new Runnable((EventLoop)eventLoop){
                final /* synthetic */ EventLoop val$eventLoop;
                {
                    this.val$eventLoop = eventLoop;
                }

                @Override
                public void run() {
                    int numElements = new Exception().getStackTrace().length;
                    int depth = executed.getAndIncrement();
                    if (depth <= 4) {
                        if (numElements <= numStackTraceElements.intValue()) {
                            future.completeExceptionally((Throwable)((Object)new AssertionError((Object)("should call run directly but stack trace decreased from " + numStackTraceElements.intValue() + " to " + numElements))));
                            return;
                        }
                        numStackTraceElements.setValue(numElements);
                        IPCUtil.execute((EventLoop)this.val$eventLoop, (Runnable)this);
                    } else if (numElements >= numStackTraceElements.intValue()) {
                        future.completeExceptionally((Throwable)((Object)new AssertionError((Object)("should call eventLoop.execute to prevent stack overflow but stack trace increased from " + numStackTraceElements.intValue() + " to " + numElements))));
                    } else {
                        future.complete(null);
                    }
                }
            });
            FutureUtils.get(future);
        }
        finally {
            eventLoop.shutdownGracefully();
        }
    }
}

