/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveTestingUtil;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, MediumTests.class})
public class TestMasterFileSystem {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMasterFileSystem.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestMasterFileSystem.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @BeforeClass
    public static void setupTest() throws Exception {
        UTIL.startMiniCluster();
    }

    @AfterClass
    public static void teardownTest() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testFsUriSetProperly() throws Exception {
        HMaster master = UTIL.getMiniHBaseCluster().getMaster();
        MasterFileSystem fs = master.getMasterFileSystem();
        Path masterRoot = CommonFSUtils.getRootDir((Configuration)fs.getConfiguration());
        Path rootDir = CommonFSUtils.getRootDir((Configuration)fs.getFileSystem().getConf());
        LOG.debug("from fs uri:" + FileSystem.getDefaultUri((Configuration)fs.getFileSystem().getConf()));
        LOG.debug("from configuration uri:" + FileSystem.getDefaultUri((Configuration)fs.getConfiguration()));
        Assert.assertEquals((Object)masterRoot, (Object)rootDir);
    }

    @Test
    public void testCheckTempDir() throws Exception {
        MasterFileSystem masterFileSystem = UTIL.getMiniHBaseCluster().getMaster().getMasterFileSystem();
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[] FAM = Bytes.toBytes((String)"fam");
        byte[][] splitKeys = new byte[][]{Bytes.toBytes((String)"b"), Bytes.toBytes((String)"c"), Bytes.toBytes((String)"d")};
        UTIL.createTable(tableName, FAM, (byte[][])splitKeys);
        List<HRegion> regions = UTIL.getHBaseCluster().getRegions(tableName);
        Assert.assertEquals((long)4L, (long)regions.size());
        try (Table table = UTIL.getConnection().getTable(tableName);){
            UTIL.loadTable(table, FAM);
        }
        UTIL.getAdmin().disableTable(tableName);
        Path tableDir = CommonFSUtils.getTableDir((Path)masterFileSystem.getRootDir(), (TableName)tableName);
        Path tempDir = masterFileSystem.getTempDir();
        Path tempTableDir = CommonFSUtils.getTableDir((Path)tempDir, (TableName)tableName);
        FileSystem fs = masterFileSystem.getFileSystem();
        if (!fs.rename(tableDir, tempTableDir)) {
            Assert.fail();
        }
        masterFileSystem.checkTempDir(tempDir, UTIL.getConfiguration(), fs);
        Assert.assertTrue((boolean)fs.exists(tempDir));
        Assert.assertEquals((long)0L, (long)fs.listStatus(tempDir).length);
        for (HRegion region : regions) {
            Path archiveDir = HFileArchiveTestingUtil.getRegionArchiveDir(UTIL.getConfiguration(), region);
            Assert.assertTrue((boolean)fs.exists(archiveDir));
        }
        UTIL.deleteTable(tableName);
    }
}

