/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.regionserver.wal.SequenceIdAccounting;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSequenceIdAccounting {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestSequenceIdAccounting.class);
    private static final byte[] ENCODED_REGION_NAME = Bytes.toBytes((String)"r");
    private static final byte[] FAMILY_NAME = Bytes.toBytes((String)"cf");
    private static final byte[] META_FAMILY = Bytes.toBytes((String)"METAFAMILY");
    private static final Set<byte[]> FAMILIES = new HashSet<byte[]>();
    private static final Set<byte[]> META_FAMILY_SET;

    @Test
    public void testStartCacheFlush() {
        SequenceIdAccounting sida = new SequenceIdAccounting();
        sida.getOrCreateLowestSequenceIds(ENCODED_REGION_NAME);
        HashMap<byte[], Long> m = new HashMap<byte[], Long>();
        m.put(ENCODED_REGION_NAME, -1L);
        Assert.assertEquals((long)-1L, (long)sida.startCacheFlush(ENCODED_REGION_NAME, FAMILIES));
        sida.completeCacheFlush(ENCODED_REGION_NAME, -1L);
        long sequenceid = 1L;
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid, true);
        Assert.assertEquals((long)-1L, (long)sida.startCacheFlush(ENCODED_REGION_NAME, FAMILIES));
        sida.completeCacheFlush(ENCODED_REGION_NAME, -1L);
        long currentSequenceId = sequenceid;
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid, true);
        HashSet<byte[]> otherFamily = new HashSet<byte[]>(1);
        otherFamily.add(Bytes.toBytes((String)"otherCf"));
        sida.update(ENCODED_REGION_NAME, FAMILIES, ++sequenceid, true);
        Assert.assertEquals((long)currentSequenceId, (long)sida.startCacheFlush(ENCODED_REGION_NAME, otherFamily));
        sida.completeCacheFlush(ENCODED_REGION_NAME, -1L);
    }

    @Test
    public void testAreAllLower() {
        SequenceIdAccounting sida = new SequenceIdAccounting();
        sida.getOrCreateLowestSequenceIds(ENCODED_REGION_NAME);
        HashMap<byte[], Long> m = new HashMap<byte[], Long>();
        m.put(ENCODED_REGION_NAME, -1L);
        Assert.assertTrue((boolean)sida.areAllLower(m));
        long sequenceid = 1L;
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        Assert.assertTrue((boolean)sida.areAllLower(m));
        m.put(ENCODED_REGION_NAME, sequenceid);
        Assert.assertFalse((boolean)sida.areAllLower(m));
        long lowest = sida.getLowestSequenceId(ENCODED_REGION_NAME);
        Assert.assertEquals((String)"Lowest should be first sequence id inserted", (long)1L, (long)lowest);
        m.put(ENCODED_REGION_NAME, lowest);
        Assert.assertFalse((boolean)sida.areAllLower(m));
        sida.startCacheFlush(ENCODED_REGION_NAME, FAMILIES);
        Assert.assertFalse((boolean)sida.areAllLower(m));
        m.put(ENCODED_REGION_NAME, -1L);
        Assert.assertTrue((boolean)sida.areAllLower(m));
        sida.completeCacheFlush(ENCODED_REGION_NAME, -1L);
        m.put(ENCODED_REGION_NAME, sequenceid);
        Assert.assertTrue((boolean)sida.areAllLower(m));
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        lowest = sida.getLowestSequenceId(ENCODED_REGION_NAME);
        m.put(ENCODED_REGION_NAME, lowest);
        Assert.assertFalse((boolean)sida.areAllLower(m));
        sida.startCacheFlush(ENCODED_REGION_NAME, FAMILIES);
        Assert.assertEquals((long)-1L, (long)sida.getLowestSequenceId(ENCODED_REGION_NAME));
        sida.completeCacheFlush(ENCODED_REGION_NAME, -1L);
        Assert.assertEquals((long)-1L, (long)sida.getLowestSequenceId(ENCODED_REGION_NAME));
        m.put(ENCODED_REGION_NAME, sequenceid);
        sida.update(ENCODED_REGION_NAME, FAMILIES, ++sequenceid, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, ++sequenceid, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, ++sequenceid, true);
        Assert.assertTrue((boolean)sida.areAllLower(m));
        m.put(ENCODED_REGION_NAME, sequenceid);
        Assert.assertFalse((boolean)sida.areAllLower(m));
        SequenceIdAccounting meta_sida = new SequenceIdAccounting();
        HashMap<byte[], Long> meta_m = new HashMap<byte[], Long>();
        meta_sida.getOrCreateLowestSequenceIds(ENCODED_REGION_NAME);
        meta_m.put(ENCODED_REGION_NAME, sequenceid);
        meta_sida.update(ENCODED_REGION_NAME, META_FAMILY_SET, ++sequenceid, true);
        meta_sida.update(ENCODED_REGION_NAME, META_FAMILY_SET, ++sequenceid, true);
        meta_sida.update(ENCODED_REGION_NAME, META_FAMILY_SET, ++sequenceid, true);
        Assert.assertTrue((boolean)meta_sida.areAllLower(meta_m));
        meta_m.put(ENCODED_REGION_NAME, sequenceid);
        Assert.assertTrue((boolean)meta_sida.areAllLower(meta_m));
    }

    @Test
    public void testFindLower() {
        SequenceIdAccounting sida = new SequenceIdAccounting();
        sida.getOrCreateLowestSequenceIds(ENCODED_REGION_NAME);
        HashMap<byte[], Long> m = new HashMap<byte[], Long>();
        m.put(ENCODED_REGION_NAME, -1L);
        long sequenceid = 1L;
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        sida.update(ENCODED_REGION_NAME, FAMILIES, sequenceid++, true);
        Assert.assertTrue((sida.findLower(m) == null ? 1 : 0) != 0);
        m.put(ENCODED_REGION_NAME, sida.getLowestSequenceId(ENCODED_REGION_NAME));
        Assert.assertTrue((sida.findLower(m).size() == 1 ? 1 : 0) != 0);
        m.put(ENCODED_REGION_NAME, sida.getLowestSequenceId(ENCODED_REGION_NAME) - 1L);
        Assert.assertTrue((sida.findLower(m) == null ? 1 : 0) != 0);
    }

    static {
        FAMILIES.add(FAMILY_NAME);
        META_FAMILY_SET = new HashSet<byte[]>();
        META_FAMILY_SET.add(META_FAMILY);
    }
}

