/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.StripedFileTestUtil;
import org.apache.hadoop.hdfs.protocol.DatanodeInfoWithStorage;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.thirdparty.com.google.common.collect.Lists;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestSafeModeWithStripedFile {
    private ErasureCodingPolicy ecPolicy;
    private short dataBlocks;
    private short parityBlocks;
    private int numDNs;
    private int cellSize;
    private int blockSize;
    private MiniDFSCluster cluster;
    private Configuration conf;
    @Rule
    public Timeout globalTimeout = new Timeout(300000);

    public ErasureCodingPolicy getEcPolicy() {
        return StripedFileTestUtil.getDefaultECPolicy();
    }

    @Before
    public void setup() throws IOException {
        this.ecPolicy = this.getEcPolicy();
        this.dataBlocks = (short)this.ecPolicy.getNumDataUnits();
        this.parityBlocks = (short)this.ecPolicy.getNumParityUnits();
        this.numDNs = this.dataBlocks + this.parityBlocks;
        this.cellSize = this.ecPolicy.getCellSize();
        this.blockSize = this.cellSize * 2;
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", (long)this.blockSize);
        this.conf.setLong("dfs.blockreport.intervalMsec", 100L);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(this.numDNs).build();
        this.cluster.getFileSystem().enableErasureCodingPolicy(this.getEcPolicy().getName());
        this.cluster.getFileSystem().getClient().setErasureCodingPolicy("/", this.getEcPolicy().getName());
        this.cluster.waitActive();
    }

    @After
    public void tearDown() throws IOException {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    @Test
    public void testStripedFile0() throws IOException {
        this.doTest(this.cellSize, 1);
    }

    @Test
    public void testStripedFile1() throws IOException {
        int numCell = this.dataBlocks - 1;
        this.doTest(this.cellSize * numCell, numCell);
    }

    private void doTest(int smallSize, int minStorages) throws IOException {
        int i;
        DatanodeInfoWithStorage[] locations;
        DistributedFileSystem fs = this.cluster.getFileSystem();
        byte[] data = StripedFileTestUtil.generateBytes(smallSize);
        Path smallFilePath = new Path("/testStripedFile_" + smallSize);
        DFSTestUtil.writeFile((FileSystem)fs, smallFilePath, data);
        int bigSize = this.blockSize * this.dataBlocks * 2;
        Path bigFilePath = new Path("/testStripedFile_" + bigSize);
        data = StripedFileTestUtil.generateBytes(bigSize);
        DFSTestUtil.writeFile((FileSystem)fs, bigFilePath, data);
        ArrayList dnprops = Lists.newArrayList();
        LocatedBlocks lbs = this.cluster.getNameNodeRpc().getBlockLocations(smallFilePath.toString(), 0L, (long)smallSize);
        for (DatanodeInfoWithStorage loc : locations = lbs.get(0).getLocations()) {
            dnprops.add(this.cluster.stopDataNode(loc.getName()));
        }
        for (int i2 = 0; i2 < this.numDNs - locations.length; ++i2) {
            dnprops.add(this.cluster.stopDataNode(0));
        }
        this.cluster.restartNameNode(0);
        NameNode nn = this.cluster.getNameNode();
        Assert.assertTrue((boolean)this.cluster.getNameNode().isInSafeMode());
        Assert.assertEquals((long)0L, (long)NameNodeAdapter.getSafeModeSafeBlocks(nn));
        for (i = 0; i < minStorages - 1; ++i) {
            this.cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)dnprops.remove(0));
            this.cluster.waitActive();
            this.cluster.triggerBlockReports();
            Assert.assertEquals((long)0L, (long)NameNodeAdapter.getSafeModeSafeBlocks(nn));
        }
        this.cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)dnprops.remove(0));
        this.cluster.waitActive();
        this.cluster.triggerBlockReports();
        Assert.assertEquals((long)1L, (long)NameNodeAdapter.getSafeModeSafeBlocks(nn));
        for (i = minStorages; i < this.dataBlocks - 1; ++i) {
            this.cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)dnprops.remove(0));
            this.cluster.waitActive();
            this.cluster.triggerBlockReports();
            Assert.assertTrue((boolean)nn.isInSafeMode());
        }
        this.cluster.restartDataNode((MiniDFSCluster.DataNodeProperties)dnprops.remove(0));
        this.cluster.waitActive();
        this.cluster.triggerBlockReports();
        Assert.assertFalse((boolean)nn.isInSafeMode());
    }
}

