/*
 * Decompiled with CFR 0.152.
 */
package io.trino.matching.pattern;

import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.matching.PatternVisitor;
import java.util.Objects;
import java.util.stream.Stream;

public class CapturePattern<T>
extends Pattern<T> {
    private final Capture<T> capture;

    public CapturePattern(Capture<T> capture, Pattern<T> previous) {
        super(previous);
        this.capture = Objects.requireNonNull(capture, "capture is null");
    }

    public Capture<T> capture() {
        return this.capture;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        Captures newCaptures = captures.addAll(Captures.ofNullable(this.capture, object));
        return Stream.of(Match.of(newCaptures));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitCapture(this);
    }
}

