/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.system.SystemSplit;
import io.trino.connector.system.SystemTableHandle;
import io.trino.connector.system.SystemTablesProvider;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public class SystemSplitManager
implements ConnectorSplitManager {
    private final InternalNodeManager nodeManager;
    private final SystemTablesProvider tables;

    public SystemSplitManager(InternalNodeManager nodeManager, SystemTablesProvider tables) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.tables = Objects.requireNonNull(tables, "tables is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, ConnectorSplitManager.SplitSchedulingStrategy splitSchedulingStrategy, DynamicFilter dynamicFilter) {
        SystemTableHandle table = (SystemTableHandle)tableHandle;
        TupleDomain<ColumnHandle> constraint = table.getConstraint();
        SystemTable systemTable = this.tables.getSystemTable(session, table.getSchemaTableName()).orElseThrow(() -> new TableNotFoundException(table.getSchemaTableName()));
        SystemTable.Distribution tableDistributionMode = systemTable.getDistribution();
        if (tableDistributionMode == SystemTable.Distribution.SINGLE_COORDINATOR) {
            HostAddress address = this.nodeManager.getCurrentNode().getHostAndPort();
            SystemSplit split = new SystemSplit(address, constraint);
            return new FixedSplitSource((Iterable)ImmutableList.of((Object)split));
        }
        ImmutableList.Builder splits = ImmutableList.builder();
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        if (tableDistributionMode == SystemTable.Distribution.ALL_COORDINATORS) {
            nodes.addAll(this.nodeManager.getCoordinators());
        } else if (tableDistributionMode == SystemTable.Distribution.ALL_NODES) {
            nodes.addAll(this.nodeManager.getNodes(NodeState.ACTIVE));
        }
        ImmutableSet nodeSet = nodes.build();
        for (InternalNode node : nodeSet) {
            splits.add((Object)new SystemSplit(node.getHostAndPort(), constraint));
        }
        return new FixedSplitSource((Iterable)splits.build());
    }
}

