/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.connector.CatalogName;
import io.trino.execution.NodeTaskMap;
import io.trino.execution.scheduler.NetworkLocation;
import io.trino.execution.scheduler.NetworkTopology;
import io.trino.execution.scheduler.NodeMap;
import io.trino.execution.scheduler.NodeSchedulerConfig;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.NodeSelectorFactory;
import io.trino.execution.scheduler.TopologyAwareNodeSelector;
import io.trino.execution.scheduler.TopologyAwareNodeSelectorConfig;
import io.trino.metadata.InternalNode;
import io.trino.metadata.InternalNodeManager;
import io.trino.metadata.NodeState;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class TopologyAwareNodeSelectorFactory
implements NodeSelectorFactory {
    private static final Logger LOG = Logger.get(TopologyAwareNodeSelectorFactory.class);
    private final Cache<InternalNode, Boolean> inaccessibleNodeLogCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private final NetworkTopology networkTopology;
    private final InternalNodeManager nodeManager;
    private final int minCandidates;
    private final boolean includeCoordinator;
    private final long maxSplitsWeightPerNode;
    private final long maxPendingSplitsWeightPerTask;
    private final NodeTaskMap nodeTaskMap;
    private final List<CounterStat> placementCounters;
    private final Map<String, CounterStat> placementCountersByName;

    @Inject
    public TopologyAwareNodeSelectorFactory(NetworkTopology networkTopology, InternalNodeManager nodeManager, NodeSchedulerConfig schedulerConfig, NodeTaskMap nodeTaskMap, TopologyAwareNodeSelectorConfig topologyConfig) {
        Objects.requireNonNull(networkTopology, "networkTopology is null");
        Objects.requireNonNull(nodeManager, "nodeManager is null");
        Objects.requireNonNull(schedulerConfig, "schedulerConfig is null");
        Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        Objects.requireNonNull(topologyConfig, "topologyConfig is null");
        this.networkTopology = networkTopology;
        this.nodeManager = nodeManager;
        this.minCandidates = schedulerConfig.getMinCandidates();
        this.includeCoordinator = schedulerConfig.isIncludeCoordinator();
        this.nodeTaskMap = Objects.requireNonNull(nodeTaskMap, "nodeTaskMap is null");
        int maxSplitsPerNode = schedulerConfig.getMaxSplitsPerNode();
        int maxPendingSplitsPerTask = schedulerConfig.getMaxPendingSplitsPerTask();
        Preconditions.checkArgument((maxSplitsPerNode >= maxPendingSplitsPerTask ? 1 : 0) != 0, (Object)"maxSplitsPerNode must be > maxPendingSplitsPerTask");
        this.maxSplitsWeightPerNode = SplitWeight.rawValueForStandardSplitCount((int)maxSplitsPerNode);
        this.maxPendingSplitsWeightPerTask = SplitWeight.rawValueForStandardSplitCount((int)maxPendingSplitsPerTask);
        ImmutableList.Builder placementCounters = ImmutableList.builder();
        ImmutableMap.Builder placementCountersByName = ImmutableMap.builder();
        CounterStat allCounter = new CounterStat();
        placementCounters.add((Object)allCounter);
        placementCountersByName.put((Object)"all", (Object)allCounter);
        for (String segmentName : ImmutableList.copyOf(topologyConfig.getLocationSegmentNames())) {
            CounterStat segmentCounter = new CounterStat();
            placementCounters.add((Object)segmentCounter);
            placementCountersByName.put((Object)segmentName, (Object)segmentCounter);
        }
        this.placementCounters = placementCounters.build();
        this.placementCountersByName = placementCountersByName.build();
    }

    public Map<String, CounterStat> getPlacementCountersByName() {
        return this.placementCountersByName;
    }

    @Override
    public NodeSelector createNodeSelector(Session session, Optional<CatalogName> catalogName) {
        Objects.requireNonNull(catalogName, "catalogName is null");
        Supplier nodeMap = Suppliers.memoizeWithExpiration(() -> this.createNodeMap(catalogName), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        return new TopologyAwareNodeSelector(this.nodeManager, this.nodeTaskMap, this.includeCoordinator, (java.util.function.Supplier<NodeMap>)nodeMap, this.minCandidates, this.maxSplitsWeightPerNode, this.maxPendingSplitsWeightPerTask, SystemSessionProperties.getMaxUnacknowledgedSplitsPerTask(session), this.placementCounters, this.networkTopology);
    }

    private NodeMap createNodeMap(Optional<CatalogName> catalogName) {
        Set nodes = catalogName.map(this.nodeManager::getActiveConnectorNodes).orElseGet(() -> this.nodeManager.getNodes(NodeState.ACTIVE));
        Set coordinatorNodeIds = (Set)this.nodeManager.getCoordinators().stream().map(InternalNode::getNodeIdentifier).collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap.Builder byHostAndPort = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder byHost = ImmutableSetMultimap.builder();
        ImmutableSetMultimap.Builder workersByNetworkPath = ImmutableSetMultimap.builder();
        for (InternalNode node : nodes) {
            if (this.includeCoordinator || !coordinatorNodeIds.contains(node.getNodeIdentifier())) {
                NetworkLocation location = this.networkTopology.locate(node.getHostAndPort());
                for (int i = 0; i <= location.getSegments().size(); ++i) {
                    workersByNetworkPath.put((Object)location.subLocation(0, i), (Object)node);
                }
            }
            try {
                byHostAndPort.put((Object)node.getHostAndPort(), (Object)node);
                byHost.put((Object)node.getInternalAddress(), (Object)node);
            }
            catch (UnknownHostException e) {
                if (this.inaccessibleNodeLogCache.getIfPresent((Object)node) != null) continue;
                this.inaccessibleNodeLogCache.put((Object)node, (Object)true);
                LOG.warn((Throwable)e, "Unable to resolve host name for node: %s", new Object[]{node});
            }
        }
        return new NodeMap((SetMultimap<HostAddress, InternalNode>)byHostAndPort.build(), (SetMultimap<InetAddress, InternalNode>)byHost.build(), (SetMultimap<NetworkLocation, InternalNode>)workersByNetworkPath.build(), coordinatorNodeIds);
    }
}

