/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.spi.type.TimeZoneKey;
import io.trino.util.DateTimeZoneIndex;

@Description(value="Millisecond of the second of the given timestamp")
@ScalarFunction(value="millisecond")
public class ExtractMillisecond {
    private ExtractMillisecond() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return DateTimeZoneIndex.unpackChronology(packedEpochMillis).millisOfSecond().get(DateTimeEncoding.unpackMillisUtc((long)packedEpochMillis));
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return DateTimeZoneIndex.getChronology(TimeZoneKey.getTimeZoneKey((short)timestamp.getTimeZoneKey())).millisOfSecond().get(timestamp.getEpochMillis());
    }
}

