/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;
import java.nio.charset.StandardCharsets;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToVarcharCast {
    private TimeWithTimeZoneToVarcharCast() {
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="time(p) with time zone") long packedTime) {
        long nanos = DateTimeEncoding.unpackTimeNanos((long)packedTime);
        int offsetMinutes = DateTimeEncoding.unpackOffsetMinutes((long)packedTime);
        return TimeWithTimeZoneToVarcharCast.formatAsString((int)precision, nanos * 1000L, offsetMinutes);
    }

    @LiteralParameters(value={"x", "p"})
    @SqlType(value="varchar(x)")
    public static Slice cast(@LiteralParameter(value="p") long precision, @SqlType(value="time(p) with time zone") LongTimeWithTimeZone time) {
        return TimeWithTimeZoneToVarcharCast.formatAsString((int)precision, time.getPicoseconds(), time.getOffsetMinutes());
    }

    private static Slice formatAsString(int precision, long picos, int offsetMinutes) {
        int size = 8 + (precision > 0 ? 1 : 0) + precision + 6;
        DynamicSliceOutput output = new DynamicSliceOutput(size);
        String formatted = String.format("%02d:%02d:%02d", picos / 3600000000000000L, picos / 60000000000000L % 60L, picos / 1000000000000L % 60L);
        output.appendBytes(formatted.getBytes(StandardCharsets.UTF_8));
        if (precision > 0) {
            long scaledFraction = picos % 1000000000000L / DateTimes.scaleFactor(precision, 12);
            output.appendByte(46);
            output.appendBytes(String.format("%0" + precision + "d", scaledFraction).getBytes(StandardCharsets.UTF_8));
        }
        output.appendBytes(String.format("%s%02d:%02d", Character.valueOf(offsetMinutes >= 0 ? (char)'+' : '-'), Math.abs(offsetMinutes / 60), Math.abs(offsetMinutes % 60)).getBytes(StandardCharsets.UTF_8));
        return output.slice();
    }
}

