/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import io.airlift.bytecode.instruction.LabelNode;
import io.trino.sql.gen.BytecodeGenerator;
import io.trino.sql.gen.BytecodeGeneratorContext;
import io.trino.sql.relational.RowExpression;
import io.trino.sql.relational.SpecialForm;
import java.util.List;
import java.util.Objects;

public class OrCodeGenerator
implements BytecodeGenerator {
    private final List<RowExpression> terms;

    public OrCodeGenerator(SpecialForm specialForm) {
        Objects.requireNonNull(specialForm, "specialForm is null");
        Preconditions.checkArgument((specialForm.getArguments().size() >= 2 ? 1 : 0) != 0);
        this.terms = specialForm.getArguments();
    }

    @Override
    public BytecodeNode generateExpression(BytecodeGeneratorContext generator) {
        Variable wasNull = generator.wasNull();
        BytecodeBlock block = new BytecodeBlock().comment("OR").setDescription("OR");
        block.push(false);
        LabelNode end = new LabelNode("end");
        LabelNode returnTrue = new LabelNode("returnTrue");
        for (int i = 0; i < this.terms.size(); ++i) {
            RowExpression term = this.terms.get(i);
            block.append(generator.generate(term));
            IfStatement ifWasNull = new IfStatement(String.format("if term %s wasNull...", i), new Object[0]).condition((BytecodeNode)wasNull);
            ifWasNull.ifTrue().comment("clear the null flag, pop residual value off stack, and push was null flag on the stack (true)").pop(term.getType().getJavaType()).pop(Boolean.TYPE).push(true);
            ifWasNull.ifFalse().comment("if term is true, short circuit and return true").ifTrueGoto(returnTrue);
            block.append((BytecodeNode)ifWasNull).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse()));
        }
        block.putVariable(wasNull).push(false).gotoLabel(end);
        block.visitLabel(returnTrue).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).pop(Boolean.TYPE).push(true);
        block.visitLabel(end);
        return block;
    }
}

