/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolsExtractor;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.ProjectOffPushDownRule;
import io.trino.sql.planner.iterative.rule.Util;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.CorrelatedJoinNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.tree.BooleanLiteral;
import java.util.Optional;
import java.util.Set;

public class PruneCorrelatedJoinColumns
extends ProjectOffPushDownRule<CorrelatedJoinNode> {
    public PruneCorrelatedJoinColumns() {
        super(Patterns.correlatedJoin());
    }

    @Override
    protected Optional<PlanNode> pushDownProjectOff(Rule.Context context, CorrelatedJoinNode correlatedJoinNode, Set<Symbol> referencedOutputs) {
        boolean pruned;
        PlanNode input = correlatedJoinNode.getInput();
        PlanNode subquery = correlatedJoinNode.getSubquery();
        if (Sets.intersection((Set)ImmutableSet.copyOf(subquery.getOutputSymbols()), referencedOutputs).isEmpty()) {
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER && QueryCardinalityUtil.isScalar(subquery, context.getLookup()) && correlatedJoinNode.getFilter().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(input);
            }
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.LEFT && QueryCardinalityUtil.isAtMostScalar(subquery, context.getLookup())) {
                return Optional.of(input);
            }
        }
        ImmutableSet referencedAndCorrelationSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(correlatedJoinNode.getCorrelation()).build();
        if (Sets.intersection((Set)ImmutableSet.copyOf(input.getOutputSymbols()), (Set)referencedAndCorrelationSymbols).isEmpty()) {
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.INNER && QueryCardinalityUtil.isScalar(input, context.getLookup()) && correlatedJoinNode.getFilter().equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(subquery);
            }
            if (correlatedJoinNode.getType() == CorrelatedJoinNode.Type.RIGHT && QueryCardinalityUtil.isAtMostScalar(input, context.getLookup())) {
                return Optional.of(subquery);
            }
        }
        Set<Symbol> filterSymbols = SymbolsExtractor.extractUnique(correlatedJoinNode.getFilter());
        ImmutableSet referencedAndFilterSymbols = ImmutableSet.builder().addAll(referencedOutputs).addAll(filterSymbols).build();
        Optional<PlanNode> newSubquery = Util.restrictOutputs(context.getIdAllocator(), subquery, (Set<Symbol>)referencedAndFilterSymbols);
        ImmutableSet referencedAndFilterAndCorrelationSymbols = ImmutableSet.builder().addAll((Iterable)referencedAndFilterSymbols).addAll(correlatedJoinNode.getCorrelation()).build();
        Optional<PlanNode> newInput = Util.restrictOutputs(context.getIdAllocator(), input, (Set<Symbol>)referencedAndFilterAndCorrelationSymbols);
        boolean bl = pruned = newSubquery.isPresent() || newInput.isPresent();
        if (pruned) {
            return Optional.of(new CorrelatedJoinNode(correlatedJoinNode.getId(), newInput.orElse(input), newSubquery.orElse(subquery), correlatedJoinNode.getCorrelation(), correlatedJoinNode.getType(), correlatedJoinNode.getFilter(), correlatedJoinNode.getOriginSubquery()));
        }
        return Optional.empty();
    }
}

