/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.ChildReplacer;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.RowNumberNode;
import java.util.List;
import java.util.Optional;

public class PushdownLimitIntoRowNumber
implements Rule<LimitNode> {
    private static final Capture<RowNumberNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(limit -> !limit.isWithTies() && limit.getCount() != 0L && limit.getCount() <= Integer.MAX_VALUE).with(Patterns.source().matching(Patterns.rowNumber().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode node, Captures captures, Rule.Context context) {
        RowNumberNode source = (RowNumberNode)captures.get(CHILD);
        RowNumberNode rowNumberNode = PushdownLimitIntoRowNumber.mergeLimit(source, node);
        if (rowNumberNode.getPartitionBy().isEmpty()) {
            return Rule.Result.ofPlanNode(rowNumberNode);
        }
        if (source.getMaxRowCountPerPartition().isPresent() && rowNumberNode.getMaxRowCountPerPartition().equals(source.getMaxRowCountPerPartition())) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(ChildReplacer.replaceChildren(node, (List<PlanNode>)ImmutableList.of((Object)rowNumberNode)));
    }

    private static RowNumberNode mergeLimit(RowNumberNode node, LimitNode limitNode) {
        int newRowCountPerPartition = Math.toIntExact(limitNode.getCount());
        if (node.getMaxRowCountPerPartition().isPresent()) {
            newRowCountPerPartition = Math.min(node.getMaxRowCountPerPartition().get(), newRowCountPerPartition);
        }
        return new RowNumberNode(node.getId(), node.getSource(), node.getPartitionBy(), limitNode.requiresPreSortedInputs() || node.isOrderSensitive(), node.getRowNumberSymbol(), Optional.of(newRowCountPerPartition), node.getHashSymbol());
    }
}

