/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.LimitNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.SortNode;
import java.util.List;

public class RemoveRedundantSortBelowLimitWithTies
implements Rule<LimitNode> {
    private static final Capture<SortNode> SORT = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().matching(LimitNode::isWithTies).with(Patterns.Limit.requiresPreSortedInputs().equalTo((Object)false)).with(Patterns.source().matching(Patterns.sort().capturedAs(SORT)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode node, Captures captures, Rule.Context context) {
        SortNode sortNode = (SortNode)captures.get(SORT);
        return Rule.Result.ofPlanNode(node.replaceChildren((List<PlanNode>)ImmutableList.of((Object)sortNode.getSource())));
    }
}

