/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.sql.presto.decoder.protobufnative;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.protobuf.ByteString;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.EnumValue;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderErrorCode;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PulsarProtobufNativeColumnDecoder {
    private static final Set<Type> SUPPORTED_PRIMITIVE_TYPES = ImmutableSet.of((Object)BooleanType.BOOLEAN, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY, (Object[])new Type[]{TimestampType.TIMESTAMP_MILLIS});
    private final Type columnType;
    private final String columnMapping;
    private final String columnName;
    protected static final String PROTOBUF_MAP_KEY_NAME = "key";
    protected static final String PROTOBUF_MAP_VALUE_NAME = "value";
    private static final long MILLIS_PER_SECOND = 1000L;
    private static final long NANOS_PER_MILLISECOND = 1000000L;

    public PulsarProtobufNativeColumnDecoder(DecoderColumnHandle columnHandle) {
        try {
            Objects.requireNonNull(columnHandle, "columnHandle is null");
            this.columnType = columnHandle.getType();
            this.columnMapping = columnHandle.getMapping();
            this.columnName = columnHandle.getName();
            Preconditions.checkArgument((!columnHandle.isInternal() ? 1 : 0) != 0, (String)"unexpected internal column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getFormatHint() == null ? 1 : 0) != 0, (String)"unexpected format hint '%s' defined for column '%s'", (Object)columnHandle.getFormatHint(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getDataFormat() == null ? 1 : 0) != 0, (String)"unexpected data format '%s' defined for column '%s'", (Object)columnHandle.getDataFormat(), (Object)this.columnName);
            Preconditions.checkArgument((columnHandle.getMapping() != null ? 1 : 0) != 0, (String)"mapping not defined for column '%s'", (Object)this.columnName);
            Preconditions.checkArgument((boolean)PulsarProtobufNativeColumnDecoder.isSupportedType(this.columnType), (String)"Unsupported column type '%s' for column '%s'", (Object)this.columnType, (Object)this.columnName);
        }
        catch (IllegalArgumentException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_USER_ERROR, (Throwable)e);
        }
    }

    private static boolean isSupportedType(Type type) {
        if (PulsarProtobufNativeColumnDecoder.isSupportedPrimitive(type)) {
            return true;
        }
        if (type instanceof ArrayType) {
            Preconditions.checkArgument((type.getTypeParameters().size() == 1 ? 1 : 0) != 0, (Object)"expecting exactly one type parameter for array");
            return PulsarProtobufNativeColumnDecoder.isSupportedType((Type)type.getTypeParameters().get(0));
        }
        if (type instanceof MapType) {
            List typeParameters = type.getTypeParameters();
            Preconditions.checkArgument((typeParameters.size() == 2 ? 1 : 0) != 0, (Object)"expecting exactly two type parameters for map");
            return PulsarProtobufNativeColumnDecoder.isSupportedType((Type)typeParameters.get(1)) && PulsarProtobufNativeColumnDecoder.isSupportedType((Type)typeParameters.get(0));
        }
        if (type instanceof RowType) {
            for (Type fieldType : type.getTypeParameters()) {
                if (PulsarProtobufNativeColumnDecoder.isSupportedType(fieldType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isSupportedPrimitive(Type type) {
        return type instanceof VarcharType || SUPPORTED_PRIMITIVE_TYPES.contains(type);
    }

    public FieldValueProvider decodeField(DynamicMessage dynamicMessage) {
        Object columnValue = PulsarProtobufNativeColumnDecoder.locateNode(dynamicMessage, this.columnMapping);
        return new ObjectValueProvider(columnValue, this.columnType, this.columnName);
    }

    private static Object locateNode(DynamicMessage element, String columnMapping) {
        Object value = element;
        for (String pathElement : Splitter.on((char)'/').omitEmptyStrings().split((CharSequence)columnMapping)) {
            if (value == null) {
                return null;
            }
            value = value.getField(value.getDescriptorForType().findFieldByName(pathElement));
        }
        return value;
    }

    private static Slice getSlice(Object value, Type type, String columnName) {
        if (value instanceof ByteString) {
            return Slices.wrappedBuffer((byte[])((ByteString)value).toByteArray());
        }
        if (value instanceof EnumValue) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)((EnumValue)value).getName()), (Type)type);
        }
        if (value instanceof byte[]) {
            return Slices.wrappedBuffer((byte[])((byte[])value));
        }
        if (type instanceof VarcharType) {
            return Varchars.truncateToLength((Slice)Slices.utf8Slice((String)value.toString()), (Type)type);
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Block serializeObject(BlockBuilder builder, Object value, Type type, String columnName) {
        if (type instanceof ArrayType) {
            return PulsarProtobufNativeColumnDecoder.serializeList(builder, value, type, columnName);
        }
        if (type instanceof MapType) {
            return PulsarProtobufNativeColumnDecoder.serializeMap(builder, value, type, columnName);
        }
        if (type instanceof RowType) {
            return PulsarProtobufNativeColumnDecoder.serializeRow(builder, value, type, columnName);
        }
        PulsarProtobufNativeColumnDecoder.serializePrimitive(builder, value, type, columnName);
        return null;
    }

    private static Block serializeList(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        List list = (List)value;
        List typeParameters = type.getTypeParameters();
        Type elementType = (Type)typeParameters.get(0);
        BlockBuilder blockBuilder = elementType.createBlockBuilder(null, list.size());
        for (Object element : list) {
            PulsarProtobufNativeColumnDecoder.serializeObject(blockBuilder, element, elementType, columnName);
        }
        if (parentBlockBuilder != null) {
            type.writeObject(parentBlockBuilder, (Object)blockBuilder.build());
            return null;
        }
        return blockBuilder.build();
    }

    private static void serializePrimitive(BlockBuilder blockBuilder, Object value, Type type, String columnName) {
        Objects.requireNonNull(blockBuilder, "parent blockBuilder is null");
        if (value == null) {
            blockBuilder.appendNull();
            return;
        }
        if (type instanceof BooleanType) {
            type.writeBoolean(blockBuilder, ((Boolean)value).booleanValue());
            return;
        }
        if ((value instanceof Integer || value instanceof Long) && (type instanceof BigintType || type instanceof IntegerType || type instanceof SmallintType || type instanceof TinyintType)) {
            type.writeLong(blockBuilder, ((Number)value).longValue());
            return;
        }
        if (type instanceof DoubleType) {
            type.writeDouble(blockBuilder, ((Double)value).doubleValue());
            return;
        }
        if (type instanceof RealType) {
            type.writeLong(blockBuilder, (long)Float.floatToIntBits(((Float)value).floatValue()));
            return;
        }
        if (type instanceof VarcharType || type instanceof VarbinaryType) {
            type.writeSlice(blockBuilder, PulsarProtobufNativeColumnDecoder.getSlice(value, type, columnName));
            return;
        }
        throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", value.getClass(), type, columnName));
    }

    private static Block serializeMap(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parentBlockBuilder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        Map map = PulsarProtobufNativeColumnDecoder.parseProtobufMap(value);
        List typeParameters = type.getTypeParameters();
        Type keyType = (Type)typeParameters.get(0);
        Type valueType = (Type)typeParameters.get(1);
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getKey() == null) continue;
            PulsarProtobufNativeColumnDecoder.serializeObject(entryBuilder, entry.getKey(), keyType, columnName);
            PulsarProtobufNativeColumnDecoder.serializeObject(entryBuilder, entry.getValue(), valueType, columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    protected static Map parseProtobufMap(Object value) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (Object mapMsg : (List)value) {
            map.put(((DynamicMessage)mapMsg).getField(((DynamicMessage)mapMsg).getDescriptorForType().findFieldByName(PROTOBUF_MAP_KEY_NAME)), ((DynamicMessage)mapMsg).getField(((DynamicMessage)mapMsg).getDescriptorForType().findFieldByName(PROTOBUF_MAP_VALUE_NAME)));
        }
        return map;
    }

    private static Block serializeRow(BlockBuilder parentBlockBuilder, Object value, Type type, String columnName) {
        if (value == null) {
            Preconditions.checkState((parentBlockBuilder != null ? 1 : 0) != 0, (Object)"parent block builder is null");
            parentBlockBuilder.appendNull();
            return null;
        }
        BlockBuilder blockBuilder = parentBlockBuilder != null ? parentBlockBuilder : type.createBlockBuilder(null, 1);
        BlockBuilder singleRowBuilder = blockBuilder.beginBlockEntry();
        Preconditions.checkState((boolean)(value instanceof DynamicMessage), (Object)"Row Field value should be DynamicMessage type.");
        DynamicMessage record = (DynamicMessage)value;
        List fields = ((RowType)type).getFields();
        for (RowType.Field field : fields) {
            Preconditions.checkState((boolean)field.getName().isPresent(), (Object)"field name not found");
            PulsarProtobufNativeColumnDecoder.serializeObject(singleRowBuilder, record.getField(((DynamicMessage)value).getDescriptorForType().findFieldByName((String)field.getName().get())), field.getType(), columnName);
        }
        blockBuilder.closeEntry();
        if (parentBlockBuilder == null) {
            return (Block)blockBuilder.getObject(0, Block.class);
        }
        return null;
    }

    private static class ObjectValueProvider
    extends FieldValueProvider {
        private final Object value;
        private final Type columnType;
        private final String columnName;

        public ObjectValueProvider(Object value, Type columnType, String columnName) {
            this.value = value;
            this.columnType = columnType;
            this.columnName = columnName;
        }

        public boolean isNull() {
            return this.value == null;
        }

        public double getDouble() {
            if (this.value instanceof Double || this.value instanceof Float) {
                return ((Number)this.value).doubleValue();
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public boolean getBoolean() {
            if (this.value instanceof Boolean) {
                return (Boolean)this.value;
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public long getLong() {
            if (this.value instanceof Long || this.value instanceof Integer) {
                return ((Number)this.value).longValue();
            }
            if (this.columnType instanceof RealType) {
                return Float.floatToIntBits(((Float)this.value).floatValue());
            }
            if (TimestampType.TIMESTAMP_MILLIS.equals((Object)this.columnType) && this.value instanceof DynamicMessage) {
                DynamicMessage message = (DynamicMessage)this.value;
                int nanos = (Integer)message.getField(message.getDescriptorForType().findFieldByName("nanos"));
                long seconds = (Long)message.getField(message.getDescriptorForType().findFieldByName("seconds"));
                long millis = seconds * 1000L + (long)nanos / 1000000L;
                return millis * 1000L;
            }
            throw new TrinoException((ErrorCodeSupplier)DecoderErrorCode.DECODER_CONVERSION_NOT_SUPPORTED, String.format("cannot decode object of '%s' as '%s' for column '%s'", this.value.getClass(), this.columnType, this.columnName));
        }

        public Slice getSlice() {
            return PulsarProtobufNativeColumnDecoder.getSlice(this.value, this.columnType, this.columnName);
        }

        public Block getBlock() {
            return PulsarProtobufNativeColumnDecoder.serializeObject(null, this.value, this.columnType, this.columnName);
        }
    }
}

