/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.discovery.store;

import io.airlift.configuration.Config;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

public class StoreConfig {
    private Duration tombstoneMaxAge = new Duration(1.0, TimeUnit.DAYS);
    private Duration garbageCollectionInterval = new Duration(1.0, TimeUnit.HOURS);
    private int maxBatchSize = 1000;
    private int queueSize = 1000;
    private Duration remoteUpdateInterval = new Duration(5.0, TimeUnit.SECONDS);
    private Duration replicationInterval = new Duration(1.0, TimeUnit.MINUTES);

    @NotNull
    public Duration getTombstoneMaxAge() {
        return this.tombstoneMaxAge;
    }

    @Config(value="store.tombstone-max-age")
    public StoreConfig setTombstoneMaxAge(Duration age) {
        this.tombstoneMaxAge = age;
        return this;
    }

    @NotNull
    public Duration getGarbageCollectionInterval() {
        return this.garbageCollectionInterval;
    }

    @Config(value="store.gc-interval")
    public StoreConfig setGarbageCollectionInterval(Duration interval) {
        this.garbageCollectionInterval = interval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    @Config(value="store.remote.max-batch-size")
    public StoreConfig setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueueSize() {
        return this.queueSize;
    }

    @Config(value="store.remote.queue-size")
    public StoreConfig setQueueSize(int queueSize) {
        this.queueSize = queueSize;
        return this;
    }

    @MinDuration(value="1ms")
    @NotNull
    public @MinDuration(value="1ms") @NotNull Duration getRemoteUpdateInterval() {
        return this.remoteUpdateInterval;
    }

    @Config(value="store.remote.update-interval")
    public StoreConfig setRemoteUpdateInterval(Duration remoteUpdateInterval) {
        this.remoteUpdateInterval = remoteUpdateInterval;
        return this;
    }

    @MinDuration(value="1ms")
    public @MinDuration(value="1ms") Duration getReplicationInterval() {
        return this.replicationInterval;
    }

    @Config(value="store.remote.replication-interval")
    public StoreConfig setReplicationInterval(Duration replicationInterval) {
        this.replicationInterval = replicationInterval;
        return this;
    }
}

