/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.spi.connector.LocalProperty;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public final class ConstantProperty<E>
implements LocalProperty<E> {
    private final E column;

    @JsonCreator
    public ConstantProperty(@JsonProperty(value="column") E column) {
        this.column = Objects.requireNonNull(column, "column is null");
    }

    @Override
    public boolean isOrderSensitive() {
        return false;
    }

    @JsonProperty
    public E getColumn() {
        return this.column;
    }

    @Override
    public Set<E> getColumns() {
        return Collections.singleton(this.column);
    }

    @Override
    public <T> Optional<LocalProperty<T>> translate(Function<E, Optional<T>> translator) {
        return translator.apply(this.column).map(ConstantProperty::new);
    }

    @Override
    public boolean isSimplifiedBy(LocalProperty<E> known) {
        return known instanceof ConstantProperty && known.equals(this);
    }

    public String toString() {
        return "C(" + this.column + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstantProperty that = (ConstantProperty)o;
        return Objects.equals(this.column, that.column);
    }

    public int hashCode() {
        return Objects.hash(this.column);
    }
}

