/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.eventlistener;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class ColumnDetail {
    private final String catalog;
    private final String schema;
    private final String table;
    private final String columnName;

    @JsonCreator
    public ColumnDetail(String catalog, String schema, String table, String columnName) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.table = Objects.requireNonNull(table, "table is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public String getTable() {
        return this.table;
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema, this.table, this.columnName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDetail entry = (ColumnDetail)obj;
        return Objects.equals(this.catalog, entry.catalog) && Objects.equals(this.schema, entry.schema) && Objects.equals(this.table, entry.table) && Objects.equals(this.columnName, entry.columnName);
    }
}

