/*
 * Decompiled with CFR 0.152.
 */
package io.trino.matching.pattern;

import io.trino.matching.Captures;
import io.trino.matching.Match;
import io.trino.matching.Pattern;
import io.trino.matching.PatternVisitor;
import io.trino.matching.Property;
import io.trino.matching.PropertyPattern;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class WithPattern<T>
extends Pattern<T> {
    private final PropertyPattern<? super T, ?, ?> propertyPattern;

    public WithPattern(PropertyPattern<? super T, ?, ?> propertyPattern, Pattern<T> previous) {
        super(previous);
        this.propertyPattern = Objects.requireNonNull(propertyPattern, "propertyPattern is null");
    }

    public Pattern<?> getPattern() {
        return this.propertyPattern.getPattern();
    }

    public Property<? super T, ?, ?> getProperty() {
        return this.propertyPattern.getProperty();
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        BiFunction<Object, ?, Optional<?>> property = this.propertyPattern.getProperty().getFunction();
        Optional<?> propertyValue = property.apply(object, context);
        return propertyValue.map(value -> this.propertyPattern.getPattern().match(value, captures, context)).orElse(Stream.of(new Match[0]));
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitWith(this);
    }
}

