/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stream.storage.impl.cluster;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import org.apache.bookkeeper.stream.proto.cluster.ClusterAssignmentData;
import org.apache.bookkeeper.stream.proto.cluster.ClusterMetadata;
import org.apache.bookkeeper.stream.storage.api.cluster.ClusterMetadataStore;

public class InMemClusterMetadataStore
implements ClusterMetadataStore {
    private final Map<Consumer<Void>, WatcherAndExecutor> watchers = Maps.newHashMap();
    private ClusterMetadata metadata;
    private ClusterAssignmentData assignmentData;

    InMemClusterMetadataStore(int numStorageContainers) {
        this.initializeCluster(numStorageContainers);
    }

    synchronized int getNumWatchers() {
        return this.watchers.size();
    }

    public synchronized boolean initializeCluster(int numStorageContainers, Optional<String> segmentStorePath) {
        this.metadata = ClusterMetadata.newBuilder().setNumStorageContainers((long)numStorageContainers).build();
        this.assignmentData = ClusterAssignmentData.newBuilder().build();
        return true;
    }

    public synchronized ClusterAssignmentData getClusterAssignmentData() {
        return this.assignmentData;
    }

    public synchronized void updateClusterAssignmentData(ClusterAssignmentData assignmentData) {
        this.assignmentData = assignmentData;
        this.watchers.values().forEach(wae -> ((WatcherAndExecutor)wae).executor.execute(() -> ((WatcherAndExecutor)wae).watcher.accept(null)));
    }

    public synchronized void watchClusterAssignmentData(Consumer<Void> watcher, Executor executor) {
        WatcherAndExecutor wae = this.watchers.get(watcher);
        if (null == wae) {
            wae = new WatcherAndExecutor(watcher, executor);
            this.watchers.put(watcher, wae);
        }
    }

    public synchronized void unwatchClusterAssignmentData(Consumer<Void> watcher) {
        this.watchers.remove(watcher);
    }

    public synchronized ClusterMetadata getClusterMetadata() {
        return this.metadata;
    }

    public synchronized void updateClusterMetadata(ClusterMetadata clusterMetadata) {
        this.metadata = clusterMetadata;
    }

    public void close() {
    }

    private static class WatcherAndExecutor {
        private final Consumer<Void> watcher;
        private final Executor executor;

        public WatcherAndExecutor(Consumer<Void> watcher, Executor executor) {
            this.watcher = watcher;
            this.executor = executor;
        }

        public Consumer<Void> getWatcher() {
            return this.watcher;
        }

        public Executor getExecutor() {
            return this.executor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WatcherAndExecutor)) {
                return false;
            }
            WatcherAndExecutor other = (WatcherAndExecutor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Consumer<Void> this$watcher = this.getWatcher();
            Consumer<Void> other$watcher = other.getWatcher();
            if (this$watcher == null ? other$watcher != null : !this$watcher.equals(other$watcher)) {
                return false;
            }
            Executor this$executor = this.getExecutor();
            Executor other$executor = other.getExecutor();
            return !(this$executor == null ? other$executor != null : !this$executor.equals(other$executor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WatcherAndExecutor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Consumer<Void> $watcher = this.getWatcher();
            result = result * 59 + ($watcher == null ? 43 : $watcher.hashCode());
            Executor $executor = this.getExecutor();
            result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
            return result;
        }

        public String toString() {
            return "InMemClusterMetadataStore.WatcherAndExecutor(watcher=" + this.getWatcher() + ", executor=" + this.getExecutor() + ")";
        }
    }
}

