/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.bookkeeper.mledger.ManagedLedgerMXBean;
import org.apache.bookkeeper.mledger.impl.ManagedLedgerImpl;
import org.apache.bookkeeper.mledger.proto.PendingBookieOpsStats;
import org.apache.bookkeeper.mledger.util.StatsBuckets;
import org.apache.pulsar.common.stats.Rate;

public class ManagedLedgerMBeanImpl
implements ManagedLedgerMXBean {
    public static final long[] ENTRY_LATENCY_BUCKETS_USEC = new long[]{500L, 1000L, 5000L, 10000L, 20000L, 50000L, 100000L, 200000L, 1000000L};
    public static final long[] ENTRY_SIZE_BUCKETS_BYTES = new long[]{128L, 512L, 1024L, 2048L, 4096L, 16384L, 102400L, 0x100000L};
    private final ManagedLedgerImpl managedLedger;
    private final Rate addEntryOps = new Rate();
    private final Rate addEntryWithReplicasOps = new Rate();
    private final Rate addEntryOpsFailed = new Rate();
    private final Rate readEntriesOps = new Rate();
    private final Rate readEntriesOpsFailed = new Rate();
    private final Rate readEntriesOpsCacheMisses = new Rate();
    private final Rate markDeleteOps = new Rate();
    private final Rate entriesRead = new Rate();
    private final LongAdder dataLedgerOpenOp = new LongAdder();
    private final LongAdder dataLedgerCloseOp = new LongAdder();
    private final LongAdder dataLedgerCreateOp = new LongAdder();
    private final LongAdder dataLedgerDeleteOp = new LongAdder();
    private final LongAdder cursorLedgerOpenOp = new LongAdder();
    private final LongAdder cursorLedgerCloseOp = new LongAdder();
    private final LongAdder cursorLedgerCreateOp = new LongAdder();
    private final LongAdder cursorLedgerDeleteOp = new LongAdder();
    private final StatsBuckets addEntryLatencyStatsUsec = new StatsBuckets(ENTRY_LATENCY_BUCKETS_USEC);
    private final StatsBuckets ledgerAddEntryLatencyStatsUsec = new StatsBuckets(ENTRY_LATENCY_BUCKETS_USEC);
    private final StatsBuckets ledgerSwitchLatencyStatsUsec = new StatsBuckets(ENTRY_LATENCY_BUCKETS_USEC);
    private final StatsBuckets entryStats = new StatsBuckets(ENTRY_SIZE_BUCKETS_BYTES);

    public ManagedLedgerMBeanImpl(ManagedLedgerImpl managedLedger) {
        this.managedLedger = managedLedger;
    }

    public void refreshStats(long period, TimeUnit unit) {
        double seconds = (double)unit.toMillis(period) / 1000.0;
        if (seconds <= 0.0) {
            return;
        }
        this.addEntryOps.calculateRate(seconds);
        this.addEntryWithReplicasOps.calculateRate(seconds);
        this.addEntryOpsFailed.calculateRate(seconds);
        this.readEntriesOps.calculateRate(seconds);
        this.readEntriesOpsFailed.calculateRate(seconds);
        this.readEntriesOpsCacheMisses.calculateRate(seconds);
        this.markDeleteOps.calculateRate(seconds);
        this.addEntryLatencyStatsUsec.refresh();
        this.ledgerAddEntryLatencyStatsUsec.refresh();
        this.ledgerSwitchLatencyStatsUsec.refresh();
        this.entryStats.refresh();
        this.entriesRead.calculateRate(seconds);
    }

    public void addAddEntrySample(long size) {
        this.addEntryOps.recordEvent(size);
        this.entryStats.addValue(size);
        this.addEntryWithReplicasOps.recordEvent(size * (long)this.managedLedger.getConfig().getWriteQuorumSize());
    }

    public void addMarkDeleteOp() {
        this.markDeleteOps.recordEvent();
    }

    public void recordAddEntryError() {
        this.addEntryOpsFailed.recordEvent();
    }

    public void recordReadEntriesError() {
        this.readEntriesOpsFailed.recordEvent();
    }

    public void recordReadEntriesOpsCacheMisses(int count, long totalSize) {
        this.readEntriesOpsCacheMisses.recordMultipleEvents((long)count, totalSize);
    }

    public void addAddEntryLatencySample(long latency, TimeUnit unit) {
        this.addEntryLatencyStatsUsec.addValue(unit.toMicros(latency));
    }

    public void addLedgerAddEntryLatencySample(long latency, TimeUnit unit) {
        this.ledgerAddEntryLatencyStatsUsec.addValue(unit.toMicros(latency));
    }

    public void addLedgerSwitchLatencySample(long latency, TimeUnit unit) {
        this.ledgerSwitchLatencyStatsUsec.addValue(unit.toMicros(latency));
    }

    public void addReadEntriesSample(int count, long totalSize) {
        this.readEntriesOps.recordMultipleEvents((long)count, totalSize);
    }

    public void addEntriesRead(int count) {
        this.entriesRead.recordEvent((long)count);
    }

    public void startDataLedgerOpenOp() {
        this.dataLedgerOpenOp.increment();
    }

    public void endDataLedgerOpenOp() {
        this.dataLedgerOpenOp.decrement();
    }

    public void startDataLedgerCloseOp() {
        this.dataLedgerCloseOp.increment();
    }

    public void endDataLedgerCloseOp() {
        this.dataLedgerCloseOp.decrement();
    }

    public void startDataLedgerCreateOp() {
        this.dataLedgerCreateOp.increment();
    }

    public void endDataLedgerCreateOp() {
        this.dataLedgerCreateOp.decrement();
    }

    public void startDataLedgerDeleteOp() {
        this.dataLedgerDeleteOp.increment();
    }

    public void endDataLedgerDeleteOp() {
        this.dataLedgerDeleteOp.decrement();
    }

    public void startCursorLedgerOpenOp() {
        this.cursorLedgerOpenOp.increment();
    }

    public void endCursorLedgerOpenOp() {
        this.cursorLedgerOpenOp.decrement();
    }

    public void startCursorLedgerCloseOp() {
        this.cursorLedgerCloseOp.increment();
    }

    public void endCursorLedgerCloseOp() {
        this.cursorLedgerCloseOp.decrement();
    }

    public void startCursorLedgerCreateOp() {
        this.cursorLedgerCreateOp.increment();
    }

    public void endCursorLedgerCreateOp() {
        this.cursorLedgerCreateOp.decrement();
    }

    public void startCursorLedgerDeleteOp() {
        this.cursorLedgerDeleteOp.increment();
    }

    public void endCursorLedgerDeleteOp() {
        this.cursorLedgerDeleteOp.decrement();
    }

    @Override
    public String getName() {
        return this.managedLedger.getName();
    }

    @Override
    public long getEntriesReadTotalCount() {
        return this.entriesRead.getTotalCount();
    }

    @Override
    public double getAddEntryMessagesRate() {
        return this.addEntryOps.getRate();
    }

    @Override
    public double getAddEntryBytesRate() {
        return this.addEntryOps.getValueRate();
    }

    @Override
    public long getAddEntryBytesTotal() {
        return this.addEntryOps.getTotalValue();
    }

    @Override
    public double getAddEntryWithReplicasBytesRate() {
        return this.addEntryWithReplicasOps.getValueRate();
    }

    @Override
    public long getAddEntryWithReplicasBytesTotal() {
        return this.addEntryWithReplicasOps.getTotalValue();
    }

    @Override
    public double getReadEntriesRate() {
        return this.readEntriesOps.getRate();
    }

    @Override
    public double getReadEntriesBytesRate() {
        return this.readEntriesOps.getValueRate();
    }

    @Override
    public long getReadEntriesBytesTotal() {
        return this.readEntriesOps.getTotalValue();
    }

    @Override
    public long getAddEntrySucceed() {
        return this.addEntryOps.getCount();
    }

    @Override
    public long getAddEntrySucceedTotal() {
        return this.addEntryOps.getTotalCount();
    }

    @Override
    public long getAddEntryErrors() {
        return this.addEntryOpsFailed.getCount();
    }

    @Override
    public long getAddEntryErrorsTotal() {
        return this.addEntryOpsFailed.getTotalCount();
    }

    @Override
    public long getReadEntriesSucceeded() {
        return this.readEntriesOps.getCount();
    }

    @Override
    public long getReadEntriesSucceededTotal() {
        return this.readEntriesOps.getTotalCount();
    }

    @Override
    public long getReadEntriesErrors() {
        return this.readEntriesOpsFailed.getCount();
    }

    @Override
    public long getReadEntriesErrorsTotal() {
        return this.readEntriesOpsFailed.getTotalCount();
    }

    @Override
    public double getReadEntriesOpsCacheMissesRate() {
        return this.readEntriesOpsCacheMisses.getRate();
    }

    @Override
    public long getReadEntriesOpsCacheMissesTotal() {
        return this.readEntriesOpsCacheMisses.getTotalCount();
    }

    @Override
    public double getMarkDeleteRate() {
        return this.markDeleteOps.getRate();
    }

    @Override
    public long getMarkDeleteTotal() {
        return this.markDeleteOps.getTotalCount();
    }

    @Override
    public double getEntrySizeAverage() {
        return this.entryStats.getAvg();
    }

    @Override
    public long[] getEntrySizeBuckets() {
        return this.entryStats.getBuckets();
    }

    @Override
    public double getAddEntryLatencyAverageUsec() {
        return this.addEntryLatencyStatsUsec.getAvg();
    }

    @Override
    public long[] getAddEntryLatencyBuckets() {
        return this.addEntryLatencyStatsUsec.getBuckets();
    }

    @Override
    public double getLedgerAddEntryLatencyAverageUsec() {
        return this.ledgerAddEntryLatencyStatsUsec.getAvg();
    }

    @Override
    public long[] getLedgerAddEntryLatencyBuckets() {
        return this.ledgerAddEntryLatencyStatsUsec.getBuckets();
    }

    @Override
    public long[] getLedgerSwitchLatencyBuckets() {
        return this.ledgerSwitchLatencyStatsUsec.getBuckets();
    }

    @Override
    public StatsBuckets getInternalAddEntryLatencyBuckets() {
        return this.addEntryLatencyStatsUsec;
    }

    @Override
    public StatsBuckets getInternalLedgerAddEntryLatencyBuckets() {
        return this.ledgerAddEntryLatencyStatsUsec;
    }

    @Override
    public StatsBuckets getInternalEntrySizeBuckets() {
        return this.entryStats;
    }

    @Override
    public double getLedgerSwitchLatencyAverageUsec() {
        return this.ledgerSwitchLatencyStatsUsec.getAvg();
    }

    @Override
    public long getStoredMessagesSize() {
        long totalSize = this.managedLedger.getTotalSize();
        long offloadedSize = this.managedLedger.getOffloadedSize();
        long bookieSize = totalSize - offloadedSize;
        return bookieSize * (long)this.managedLedger.getConfig().getWriteQuorumSize() + offloadedSize;
    }

    @Override
    public long getStoredMessagesLogicalSize() {
        return this.managedLedger.getTotalSize();
    }

    @Override
    public long getNumberOfMessagesInBacklog() {
        long count = 0L;
        for (ManagedCursor cursor : this.managedLedger.getCursors()) {
            count += cursor.getNumberOfEntriesInBacklog(false);
        }
        return count;
    }

    @Override
    public PendingBookieOpsStats getPendingBookieOpsStats() {
        PendingBookieOpsStats result = new PendingBookieOpsStats();
        result.dataLedgerOpenOp = this.dataLedgerOpenOp.longValue();
        result.dataLedgerCloseOp = this.dataLedgerCloseOp.longValue();
        result.dataLedgerCreateOp = this.dataLedgerCreateOp.longValue();
        result.dataLedgerDeleteOp = this.dataLedgerDeleteOp.longValue();
        result.cursorLedgerOpenOp = this.cursorLedgerOpenOp.longValue();
        result.cursorLedgerCloseOp = this.cursorLedgerCloseOp.longValue();
        result.cursorLedgerCreateOp = this.cursorLedgerCreateOp.longValue();
        result.cursorLedgerDeleteOp = this.cursorLedgerDeleteOp.longValue();
        return result;
    }
}

