/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.internal;

import io.opentelemetry.instrumentation.api.internal.ConfigPropertiesUtil;
import java.util.Arrays;
import java.util.HashSet;

public final class SemconvStability {
    private static final boolean emitOldHttpSemconv;
    private static final boolean emitStableHttpSemconv;
    private static final boolean emitOldJvmSemconv;
    private static final boolean emitStableJvmSemconv;

    public static boolean emitOldHttpSemconv() {
        return emitOldHttpSemconv;
    }

    public static boolean emitStableHttpSemconv() {
        return emitStableHttpSemconv;
    }

    public static boolean emitOldJvmSemconv() {
        return emitOldJvmSemconv;
    }

    public static boolean emitStableJvmSemconv() {
        return emitStableJvmSemconv;
    }

    private SemconvStability() {
    }

    static {
        boolean oldHttp = true;
        boolean stableHttp = false;
        boolean oldJvm = true;
        boolean stableJvm = false;
        String value = ConfigPropertiesUtil.getString("otel.semconv-stability.opt-in");
        if (value != null) {
            HashSet<String> values = new HashSet<String>(Arrays.asList(value.split(",")));
            if (values.contains("http")) {
                oldHttp = false;
                stableHttp = true;
            }
            if (values.contains("http/dup")) {
                oldHttp = true;
                stableHttp = true;
            }
            if (values.contains("jvm")) {
                oldJvm = false;
                stableJvm = true;
            }
            if (values.contains("jvm/dup")) {
                oldJvm = true;
                stableJvm = true;
            }
        }
        emitOldHttpSemconv = oldHttp;
        emitStableHttpSemconv = stableHttp;
        emitOldJvmSemconv = oldJvm;
        emitStableJvmSemconv = stableJvm;
    }
}

