/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.txn.BuddyLocker;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.txn.WriteLockInfo;

public class ReadCommittedLocker
extends BuddyLocker {
    private ReadCommittedLocker(EnvironmentImpl env, Locker buddy) {
        super(env, buddy instanceof ReadCommittedLocker ? ((ReadCommittedLocker)buddy).getBuddy() : buddy);
        assert (this.getBuddy() instanceof Txn);
    }

    public static ReadCommittedLocker createReadCommittedLocker(EnvironmentImpl env, Locker buddy) throws DatabaseException {
        return new ReadCommittedLocker(env, buddy);
    }

    @Override
    public Locker newNonTxnLocker() throws DatabaseException {
        return ReadCommittedLocker.createReadCommittedLocker(this.envImpl, this.getBuddy().newNonTxnLocker());
    }

    @Override
    protected LockResult lockInternal(long lsn, LockType lockType, boolean noWait, boolean jumpAheadOfWaiters, DatabaseImpl database) throws DatabaseException {
        if (lockType.isWriteLock()) {
            return this.getBuddy().lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
        }
        return super.lockInternal(lsn, lockType, noWait, jumpAheadOfWaiters, database);
    }

    @Override
    public boolean releaseLock(long lsn) throws DatabaseException {
        boolean ret = true;
        if (!this.lockManager.release(lsn, this)) {
            ret = this.lockManager.release(lsn, this.getBuddy());
        }
        this.removeLock(lsn);
        return ret;
    }

    @Override
    public WriteLockInfo getWriteLockInfo(long lsn) {
        return this.getBuddy().getWriteLockInfo(lsn);
    }

    @Override
    public void markDeleteAtTxnEnd(DatabaseImpl db, boolean deleteAtCommit) {
        this.getBuddy().markDeleteAtTxnEnd(db, deleteAtCommit);
    }

    @Override
    public void addDeleteInfo(BIN bin) {
        this.getBuddy().addDeleteInfo(bin);
    }

    @Override
    public void registerCursor(CursorImpl cursor) {
        this.getBuddy().registerCursor(cursor);
    }

    @Override
    public void unRegisterCursor(CursorImpl cursor) {
        this.getBuddy().unRegisterCursor(cursor);
    }

    @Override
    public boolean lockingRequired() {
        return true;
    }

    @Override
    public boolean isTransactional() {
        return true;
    }

    @Override
    public boolean isReadCommittedIsolation() {
        return true;
    }
}

