/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8.transport;

import org.apache.qpid.server.QpidException;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQShortString;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBody;
import org.apache.qpid.server.protocol.v0_8.transport.AMQMethodBodyImpl;
import org.apache.qpid.server.protocol.v0_8.transport.EncodableAMQDataBlock;
import org.apache.qpid.server.protocol.v0_8.transport.MethodDispatcher;
import org.apache.qpid.server.protocol.v0_8.transport.ServerChannelMethodProcessor;

public class BasicPublishBody
extends AMQMethodBodyImpl
implements EncodableAMQDataBlock,
AMQMethodBody {
    public static final int CLASS_ID = 60;
    public static final int METHOD_ID = 40;
    private final int _ticket;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final byte _bitfield0;

    public BasicPublishBody(int ticket, AMQShortString exchange, AMQShortString routingKey, boolean mandatory, boolean immediate) {
        this._ticket = ticket;
        this._exchange = exchange;
        this._routingKey = routingKey;
        byte bitfield0 = 0;
        if (mandatory) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (immediate) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
    }

    @Override
    public int getClazz() {
        return 60;
    }

    @Override
    public int getMethod() {
        return 40;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    public final boolean getMandatory() {
        return (this._bitfield0 & 1) != 0;
    }

    public final boolean getImmediate() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    protected int getBodySize() {
        int size = 3;
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._routingKey);
    }

    @Override
    public void writeMethodPayload(QpidByteBuffer buffer) {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeBitfield(buffer, this._bitfield0);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws QpidException {
        return dispatcher.dispatchBasicPublish(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[BasicPublishBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("mandatory=");
        buf.append(this.getMandatory());
        buf.append(", ");
        buf.append("immediate=");
        buf.append(this.getImmediate());
        buf.append("]");
        return buf.toString();
    }

    public static void process(QpidByteBuffer buffer, ServerChannelMethodProcessor dispatcher) {
        boolean immediate;
        int ticket = buffer.getUnsignedShort();
        AMQShortString exchange = AMQShortString.readAMQShortString(buffer);
        AMQShortString routingKey = AMQShortString.readAMQShortString(buffer);
        byte bitfield = buffer.get();
        boolean mandatory = (bitfield & 1) != 0;
        boolean bl = immediate = (bitfield & 2) != 0;
        if (!dispatcher.ignoreAllButCloseOk()) {
            dispatcher.receiveBasicPublish(exchange, routingKey, mandatory, immediate);
        }
    }
}

