/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObjectCustomSerialization;

public class ConfiguredObjectJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final ConfiguredObjectJacksonModule INSTANCE = new ConfiguredObjectJacksonModule(false);
    private static final ConfiguredObjectJacksonModule PERSISTENCE_INSTANCE = new ConfiguredObjectJacksonModule(true);
    private static final Set<String> OBJECT_METHOD_NAMES = Collections.synchronizedSet(new HashSet());

    private ConfiguredObjectJacksonModule(boolean forPersistence) {
        super("ConfiguredObjectSerializer", new Version(1, 0, 0, null, "org.apache.qpid", "broker-core"));
        for (final ConfiguredObjectCustomSerialization.Converter<?> converter : ConfiguredObjectCustomSerialization.getConverters(forPersistence)) {
            this.addSerializer(converter.getConversionClass(), new JsonSerializer(){

                public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                    gen.writeObject(converter.convert(value));
                }
            });
        }
    }

    public static ObjectMapper newObjectMapper(boolean forPersistence) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)(forPersistence ? PERSISTENCE_INSTANCE : INSTANCE));
        return objectMapper;
    }

    static {
        for (Method method : Object.class.getMethods()) {
            OBJECT_METHOD_NAMES.add(method.getName());
        }
    }
}

