/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0;

import java.util.ArrayList;
import org.apache.qpid.server.message.MessageSource;
import org.apache.qpid.server.model.LifetimePolicy;
import org.apache.qpid.server.model.Queue;
import org.apache.qpid.server.protocol.v1_0.SendingDestination;
import org.apache.qpid.server.protocol.v1_0.type.Outcome;
import org.apache.qpid.server.protocol.v1_0.type.Symbol;
import org.apache.qpid.server.protocol.v1_0.type.messaging.Accepted;

public class StandardSendingDestination
implements SendingDestination {
    private static final Accepted ACCEPTED = new Accepted();
    private static final Outcome[] OUTCOMES = new Outcome[]{ACCEPTED};
    private final MessageSource _messageSource;
    private final Symbol[] _capabilities;

    public StandardSendingDestination(MessageSource messageSource) {
        this._messageSource = messageSource;
        ArrayList<Symbol> capabilities = new ArrayList<Symbol>();
        if (this._messageSource instanceof Queue) {
            LifetimePolicy queueLifetimePolicy = ((Queue)this._messageSource).getLifetimePolicy();
            if (LifetimePolicy.PERMANENT == queueLifetimePolicy) {
                capabilities.add(Symbol.getSymbol("queue"));
            } else {
                capabilities.add(Symbol.getSymbol("temporary-queue"));
            }
        }
        this._capabilities = capabilities.toArray(new Symbol[capabilities.size()]);
    }

    public Outcome[] getOutcomes() {
        return OUTCOMES;
    }

    @Override
    public MessageSource getMessageSource() {
        return this._messageSource;
    }

    @Override
    public Symbol[] getCapabilities() {
        return this._capabilities;
    }
}

