/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.provider.amqp;

import java.util.function.Function;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionSecurityException;
import org.apache.qpid.jms.provider.exceptions.ProviderConnectionSecuritySaslException;
import org.apache.qpid.jms.sasl.Mechanism;
import org.apache.qpid.jms.sasl.SaslSecurityRuntimeException;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.Transport;

public class AmqpSaslAuthenticator {
    private final Function<String[], Mechanism> mechanismFinder;
    private Mechanism mechanism;
    private boolean complete;
    private ProviderConnectionSecurityException failureCause;

    public AmqpSaslAuthenticator(Function<String[], Mechanism> mechanismFinder) {
        this.mechanismFinder = mechanismFinder;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public ProviderConnectionSecurityException getFailureCause() {
        return this.failureCause;
    }

    public boolean wasSuccessful() throws IllegalStateException {
        if (this.complete) {
            return this.failureCause == null;
        }
        throw new IllegalStateException("Authentication has not completed yet.");
    }

    public void handleSaslMechanisms(Sasl sasl, Transport transport) {
        block5: {
            try {
                String[] remoteMechanisms = sasl.getRemoteMechanisms();
                if (remoteMechanisms == null || remoteMechanisms.length == 0) break block5;
                try {
                    this.mechanism = this.mechanismFinder.apply(remoteMechanisms);
                }
                catch (SaslSecurityRuntimeException ssre) {
                    this.recordFailure("Could not find a suitable SASL mechanism. " + ssre.getMessage(), ssre);
                    return;
                }
                byte[] response = this.mechanism.getInitialResponse();
                if (response != null) {
                    sasl.send(response, 0, response.length);
                }
                sasl.setMechanisms(new String[]{this.mechanism.getName()});
            }
            catch (Throwable error) {
                this.recordFailure("Exception while processing SASL init: " + error.getMessage(), error);
            }
        }
    }

    public void handleSaslChallenge(Sasl sasl, Transport transport) {
        try {
            if (sasl.pending() >= 0) {
                byte[] challenge = new byte[sasl.pending()];
                sasl.recv(challenge, 0, challenge.length);
                byte[] response = this.mechanism.getChallengeResponse(challenge);
                if (response != null) {
                    sasl.send(response, 0, response.length);
                }
            }
        }
        catch (Throwable error) {
            this.recordFailure("Exception while processing SASL step: " + error.getMessage(), error);
        }
    }

    public void handleSaslOutcome(Sasl sasl, Transport transport) {
        try {
            switch (sasl.getState()) {
                case PN_SASL_FAIL: {
                    this.handleSaslFail(sasl);
                    break;
                }
                case PN_SASL_PASS: {
                    this.handleSaslCompletion(sasl);
                    break;
                }
            }
        }
        catch (Throwable error) {
            this.recordFailure(error.getMessage(), error);
        }
    }

    private void handleSaslFail(Sasl sasl) {
        Sasl.SaslOutcome outcome;
        StringBuilder message = new StringBuilder("Client failed to authenticate");
        if (this.mechanism != null) {
            message.append(" using SASL: ").append(this.mechanism.getName());
            if (this.mechanism.getAdditionalFailureInformation() != null) {
                message.append(" (").append(this.mechanism.getAdditionalFailureInformation()).append(")");
            }
        }
        if ((outcome = sasl.getOutcome()).equals((Object)Sasl.SaslOutcome.PN_SASL_TEMP)) {
            message.append(", due to temporary system error.");
        }
        this.recordFailure(message.toString(), null, outcome.getCode());
    }

    private void handleSaslCompletion(Sasl sasl) {
        try {
            if (sasl.pending() != 0) {
                byte[] additionalData = new byte[sasl.pending()];
                sasl.recv(additionalData, 0, additionalData.length);
                this.mechanism.getChallengeResponse(additionalData);
            }
            this.mechanism.verifyCompletion();
            this.complete = true;
        }
        catch (Throwable error) {
            this.recordFailure("Exception while processing SASL exchange completion: " + error.getMessage(), error);
        }
    }

    private void recordFailure(String message, Throwable cause) {
        this.recordFailure(message, cause, Sasl.SaslOutcome.PN_SASL_NONE.getCode());
    }

    private void recordFailure(String message, Throwable cause, int outcome) {
        this.failureCause = new ProviderConnectionSecuritySaslException(message, outcome, cause);
        this.complete = true;
    }
}

