/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Chr$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the ASCII character having the binary equivalent to `expr`. If n is larger than 256 the result is equivalent to chr(n % 256)", examples="\n    Examples:\n      > SELECT _FUNC_(65);\n       A\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005]f\u0001B\r\u001b\u0001\u001eB\u0001\u0002\u0012\u0001\u0003\u0016\u0004%\t!\u0012\u0005\t\u0013\u0002\u0011\t\u0012)A\u0005\r\")!\n\u0001C\u0001\u0017\")a\n\u0001C!\u001f\")1\u000b\u0001C!)\")a\f\u0001C)?\")Q\r\u0001C!M\")A\u000f\u0001C)k\"9\u0001\u0010AA\u0001\n\u0003I\bbB>\u0001#\u0003%\t\u0001 \u0005\n\u0003\u001f\u0001\u0011\u0011!C!\u0003#A\u0011\"a\t\u0001\u0003\u0003%\t!!\n\t\u0013\u00055\u0002!!A\u0005\u0002\u0005=\u0002\"CA\u001b\u0001\u0005\u0005I\u0011IA\u001c\u0011%\t)\u0005AA\u0001\n\u0003\t9\u0005C\u0005\u0002L\u0001\t\t\u0011\"\u0011\u0002N!I\u0011\u0011\u000b\u0001\u0002\u0002\u0013\u0005\u00131K\u0004\n\u0003oR\u0012\u0011!E\u0001\u0003s2\u0001\"\u0007\u000e\u0002\u0002#\u0005\u00111\u0010\u0005\u0007\u0015N!\t!a%\t\u0013\u0005U5#!A\u0005F\u0005]\u0005\"CAM'\u0005\u0005I\u0011QAN\u0011%\tyjEA\u0001\n\u0003\u000b\t\u000bC\u0005\u0002.N\t\t\u0011\"\u0003\u00020\n\u00191\t\u001b:\u000b\u0005ma\u0012aC3yaJ,7o]5p]NT!!\b\u0010\u0002\u0011\r\fG/\u00197zgRT!a\b\u0011\u0002\u0007M\fHN\u0003\u0002\"E\u0005)1\u000f]1sW*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u0019b\u0001\u0001\u0015-_IB\u0004CA\u0015+\u001b\u0005Q\u0012BA\u0016\u001b\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u0015.\u0013\tq#D\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tI\u0003'\u0003\u000225\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\t\u0019d'D\u00015\u0015\u0005)\u0014!B:dC2\f\u0017BA\u001c5\u0005\u001d\u0001&o\u001c3vGR\u0004\"!O!\u000f\u0005izdBA\u001e?\u001b\u0005a$BA\u001f'\u0003\u0019a$o\\8u}%\tQ'\u0003\u0002Ai\u00059\u0001/Y2lC\u001e,\u0017B\u0001\"D\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0001E'A\u0003dQ&dG-F\u0001G!\tIs)\u0003\u0002I5\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011A*\u0014\t\u0003S\u0001AQ\u0001R\u0002A\u0002\u0019\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001Q!\t\u0019\u0014+\u0003\u0002Si\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\tQ\u000bE\u0002:-bK!aV\"\u0003\u0007M+\u0017\u000f\u0005\u0002Z96\t!L\u0003\u0002\\=\u0005)A/\u001f9fg&\u0011QL\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011\u0001m\u0019\t\u0003g\u0005L!A\u0019\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003e\r\u0001\u0007\u0001-A\u0002m_:\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007\u001dl'\u000f\u0005\u0002iW6\t\u0011N\u0003\u0002k5\u000591m\u001c3fO\u0016t\u0017B\u00017j\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00028\b\u0001\u0004y\u0017aA2uqB\u0011\u0001\u000e]\u0005\u0003c&\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003t\u000f\u0001\u0007q-\u0001\u0002fm\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"\u0001\u0014<\t\u000b]D\u0001\u0019\u0001$\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0011AJ\u001f\u0005\b\t&\u0001\n\u00111\u0001G\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012! \u0016\u0003\rz\\\u0013a \t\u0005\u0003\u0003\tY!\u0004\u0002\u0002\u0004)!\u0011QAA\u0004\u0003%)hn\u00195fG.,GMC\u0002\u0002\nQ\n!\"\u00198o_R\fG/[8o\u0013\u0011\ti!a\u0001\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"\u0001\u0003mC:<'BAA\u000f\u0003\u0011Q\u0017M^1\n\t\u0005\u0005\u0012q\u0003\u0002\u0007'R\u0014\u0018N\\4\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005\u001d\u0002cA\u001a\u0002*%\u0019\u00111\u0006\u001b\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007\u0001\f\t\u0004C\u0005\u000245\t\t\u00111\u0001\u0002(\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u000f\u0011\u000b\u0005m\u0012\u0011\t1\u000e\u0005\u0005u\"bAA i\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005\r\u0013Q\b\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002Q\u0003\u0013B\u0001\"a\r\u0010\u0003\u0003\u0005\r\u0001Y\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u0014\u0005=\u0003\"CA\u001a!\u0005\u0005\t\u0019AA\u0014\u0003\u0019)\u0017/^1mgR\u0019\u0001+!\u0016\t\u0011\u0005M\u0012#!AA\u0002\u0001D3\u0003AA-\u0003?\n\t'!\u001a\u0002h\u0005-\u0014QNA9\u0003g\u00022!KA.\u0013\r\tiF\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\t\u0019'AA\u0014?\u001a+fjQ0)Kb\u0004(/\u000b\u0011.AI+G/\u001e:og\u0002\"\b.\u001a\u0011B'\u000eK\u0015\nI2iCJ\f7\r^3sA!\fg/\u001b8hAQDW\r\t2j]\u0006\u0014\u0018\u0010I3rk&4\u0018\r\\3oi\u0002\"x\u000e\t1fqB\u0014\bM\f\u0011JM\u0002r\u0007%[:!Y\u0006\u0014x-\u001a:!i\"\fg\u000e\t\u001a6m\u0001\"\b.\u001a\u0011sKN,H\u000e\u001e\u0011jg\u0002*\u0017/^5wC2,g\u000e\u001e\u0011u_\u0002\u001a\u0007N\u001d\u0015oA\u0015\u0002#'\u000e\u001c*\u0003!)\u00070Y7qY\u0016\u001c\u0018EAA5\u0003UR\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006FN\u001b*w)\u0001\u0003\u0005\t\u0011!A\u0001\n%\u0002\t\u0011\u0002\u000bMLgnY3\"\u0005\u0005=\u0014!\u0002\u001a/g9\u0002\u0014!B4s_V\u0004\u0018EAA;\u00031\u0019HO]5oO~3WO\\2t\u0003\r\u0019\u0005N\u001d\t\u0003SM\u0019RaEA?\u0003\u0013\u0003b!a \u0002\u0006\u001acUBAAA\u0015\r\t\u0019\tN\u0001\beVtG/[7f\u0013\u0011\t9)!!\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0005\u0003\u0002\f\u0006EUBAAG\u0015\u0011\ty)a\u0007\u0002\u0005%|\u0017b\u0001\"\u0002\u000eR\u0011\u0011\u0011P\u0001\ti>\u001cFO]5oOR\u0011\u00111C\u0001\u0006CB\u0004H.\u001f\u000b\u0004\u0019\u0006u\u0005\"\u0002#\u0017\u0001\u00041\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u0003G\u000bI\u000b\u0005\u00034\u0003K3\u0015bAATi\t1q\n\u001d;j_:D\u0001\"a+\u0018\u0003\u0003\u0005\r\u0001T\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GCAAY!\u0011\t)\"a-\n\t\u0005U\u0016q\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class Chr
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Chr x$0) {
        return Chr$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Chr, A> g) {
        return Chr$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Chr> compose(Function1<A$, Expression> g) {
        return Chr$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object lon) {
        long longVal = BoxesRunTime.unboxToLong((Object)lon);
        if (longVal < 0L) {
            return UTF8String.EMPTY_UTF8;
        }
        if ((longVal & 0xFFL) == 0L) {
            return UTF8String.fromString((String)Character.toString('\u0000'));
        }
        return UTF8String.fromString((String)Character.toString((char)(longVal & 0xFFL)));
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)lon -> "\n        if (" + lon + " < 0) {\n          " + ev.value() + " = UTF8String.EMPTY_UTF8;\n        } else if ((" + lon + " & 0xFF) == 0) {\n          " + ev.value() + " = UTF8String.fromString(String.valueOf(Character.MIN_VALUE));\n        } else {\n          char c = (char)(" + lon + " & 0xFF);\n          " + ev.value() + " = UTF8String.fromString(String.valueOf(c));\n        }\n      ");
    }

    @Override
    public Chr withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Chr copy(Expression child) {
        return new Chr(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Chr";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Chr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Chr)) return false;
        boolean bl = true;
        if (!bl) return false;
        Chr chr = (Chr)x$1;
        Expression expression = this.child();
        Expression expression2 = chr.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!chr.canEqual(this)) return false;
        return true;
    }

    public Chr(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

