/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Substring$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.internal.types.StringTypeWithCollation$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.ByteArray;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(str, pos[, len]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n\n    _FUNC_(str FROM pos[ FOR len]]) - Returns the substring of `str` that starts at `pos` and is of length `len`, or the slice of byte array that starts at `pos` and is of length `len`.\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('Spark SQL', 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL', -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL', 5, 1);\n       k\n      > SELECT _FUNC_('Spark SQL' FROM 5);\n       k SQL\n      > SELECT _FUNC_('Spark SQL' FROM -3);\n       SQL\n      > SELECT _FUNC_('Spark SQL' FROM 5 FOR 1);\n       k\n      > SELECT _FUNC_(encode('Spark SQL', 'utf-8'), 5);\n       k SQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\t\u001da\u0001\u0002\u0013&\u0001JB\u0001\u0002\u0014\u0001\u0003\u0016\u0004%\t!\u0014\u0005\t#\u0002\u0011\t\u0012)A\u0005\u001d\"A!\u000b\u0001BK\u0002\u0013\u0005Q\n\u0003\u0005T\u0001\tE\t\u0015!\u0003O\u0011!!\u0006A!f\u0001\n\u0003i\u0005\u0002C+\u0001\u0005#\u0005\u000b\u0011\u0002(\t\u000bY\u0003A\u0011A,\t\u000bq\u0003A\u0011I/\t\u000bY\u0003A\u0011A1\t\u000b\u0011\u0004A\u0011I3\t\u000b1\u0004A\u0011I7\t\u000bQ\u0004A\u0011I'\t\u000bU\u0004A\u0011I'\t\u000bY\u0004A\u0011I'\t\u000b]\u0004A\u0011\t=\t\u000f\u0005\u0005\u0001\u0001\"\u0011\u0002\u0004!9\u0011q\u0004\u0001\u0005R\u0005\u0005\u0002\"CA\u0018\u0001\u0005\u0005I\u0011AA\u0019\u0011%\tI\u0004AI\u0001\n\u0003\tY\u0004C\u0005\u0002R\u0001\t\n\u0011\"\u0001\u0002<!I\u00111\u000b\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003+\u0002\u0011\u0011!C!\u0003/B\u0011\"!\u001b\u0001\u0003\u0003%\t!a\u001b\t\u0013\u0005M\u0004!!A\u0005\u0002\u0005U\u0004\"CA>\u0001\u0005\u0005I\u0011IA?\u0011%\tY\tAA\u0001\n\u0003\ti\tC\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\"I\u0011q\u0013\u0001\u0002\u0002\u0013\u0005\u0013\u0011T\u0004\n\u0003{+\u0013\u0011!E\u0001\u0003\u007f3\u0001\u0002J\u0013\u0002\u0002#\u0005\u0011\u0011\u0019\u0005\u0007-z!\t!!7\t\u0013\u0005mg$!A\u0005F\u0005u\u0007\"CAp=\u0005\u0005I\u0011QAq\u0011%\tIOHA\u0001\n\u0003\u000bY\u000fC\u0005\u0002~z\t\t\u0011\"\u0003\u0002\u0000\nI1+\u001e2tiJLgn\u001a\u0006\u0003M\u001d\n1\"\u001a=qe\u0016\u001c8/[8og*\u0011\u0001&K\u0001\tG\u0006$\u0018\r\\=ti*\u0011!fK\u0001\u0004gFd'B\u0001\u0017.\u0003\u0015\u0019\b/\u0019:l\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\u0004\u0001M)\u0001aM\u001c;\u0001B\u0011A'N\u0007\u0002K%\u0011a'\n\u0002\u0012)\u0016\u0014h.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u001b9\u0013\tITE\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\u001d\u0001&o\u001c3vGR\u0004\"!Q%\u000f\u0005\t;eBA\"G\u001b\u0005!%BA#2\u0003\u0019a$o\\8u}%\tQ(\u0003\u0002Iy\u00059\u0001/Y2lC\u001e,\u0017B\u0001&L\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\tAE(A\u0002tiJ,\u0012A\u0014\t\u0003i=K!\u0001U\u0013\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0003tiJ\u0004\u0013a\u00019pg\u0006!\u0001o\\:!\u0003\raWM\\\u0001\u0005Y\u0016t\u0007%\u0001\u0004=S:LGO\u0010\u000b\u00051fS6\f\u0005\u00025\u0001!)Aj\u0002a\u0001\u001d\")!k\u0002a\u0001\u001d\")Ak\u0002a\u0001\u001d\u0006qa.\u001e7m\u0013:$x\u000e\\3sC:$X#\u00010\u0011\u0005mz\u0016B\u00011=\u0005\u001d\u0011un\u001c7fC:$2\u0001\u00172d\u0011\u0015a\u0015\u00021\u0001O\u0011\u0015\u0011\u0016\u00021\u0001O\u0003!!\u0017\r^1UsB,W#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%L\u0013!\u0002;za\u0016\u001c\u0018BA6i\u0005!!\u0015\r^1UsB,\u0017AC5oaV$H+\u001f9fgV\ta\u000eE\u0002B_FL!\u0001]&\u0003\u0007M+\u0017\u000f\u0005\u0002he&\u00111\u000f\u001b\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\fQAZ5sgR\faa]3d_:$\u0017!\u0002;iSJ$\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003B=}}~\u0004\"a\u000f>\n\u0005md$aA!os\")Qp\u0004a\u0001s\u000611\u000f\u001e:j]\u001eDQAU\bA\u0002eDQ\u0001V\bA\u0002e\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\r\u0005\u0015\u0011\u0011CA\u000e!\u0011\t9!!\u0004\u000e\u0005\u0005%!bAA\u0006K\u000591m\u001c3fO\u0016t\u0017\u0002BA\b\u0003\u0013\u0011\u0001\"\u0012=qe\u000e{G-\u001a\u0005\b\u0003'\u0001\u0002\u0019AA\u000b\u0003\r\u0019G\u000f\u001f\t\u0005\u0003\u000f\t9\"\u0003\u0003\u0002\u001a\u0005%!AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\b\u0003;\u0001\u0002\u0019AA\u0003\u0003\t)g/A\fxSRDg*Z<DQ&dGM]3o\u0013:$XM\u001d8bYR9\u0001,a\t\u0002(\u0005-\u0002BBA\u0013#\u0001\u0007a*\u0001\u0005oK^4\u0015N]:u\u0011\u0019\tI#\u0005a\u0001\u001d\u0006Ia.Z<TK\u000e|g\u000e\u001a\u0005\u0007\u0003[\t\u0002\u0019\u0001(\u0002\u00119,w\u000f\u00165je\u0012\fAaY8qsR9\u0001,a\r\u00026\u0005]\u0002b\u0002'\u0013!\u0003\u0005\rA\u0014\u0005\b%J\u0001\n\u00111\u0001O\u0011\u001d!&\u0003%AA\u00029\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002>)\u001aa*a\u0010,\u0005\u0005\u0005\u0003\u0003BA\"\u0003\u001bj!!!\u0012\u000b\t\u0005\u001d\u0013\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0013=\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u001f\n)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0015TBAA/\u0015\u0011\ty&!\u0019\u0002\t1\fgn\u001a\u0006\u0003\u0003G\nAA[1wC&!\u0011qMA/\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011Q\u000e\t\u0004w\u0005=\u0014bAA9y\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u00110a\u001e\t\u0013\u0005e\u0004$!AA\u0002\u00055\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u0000A)\u0011\u0011QADs6\u0011\u00111\u0011\u0006\u0004\u0003\u000bc\u0014AC2pY2,7\r^5p]&!\u0011\u0011RAB\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007y\u000by\t\u0003\u0005\u0002zi\t\t\u00111\u0001z\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005e\u0013Q\u0013\u0005\n\u0003sZ\u0012\u0011!a\u0001\u0003[\na!Z9vC2\u001cHc\u00010\u0002\u001c\"A\u0011\u0011\u0010\u000f\u0002\u0002\u0003\u0007\u0011\u0010K\n\u0001\u0003?\u000b)+a*\u0002,\u00065\u0016\u0011WAZ\u0003o\u000bI\fE\u00025\u0003CK1!a)&\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!!+\u0002\u0005CT\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014H\u0006\t9pgnc\u0003\u0005\\3o;&\u0002S\u0006\t*fiV\u0014hn\u001d\u0011uQ\u0016\u00043/\u001e2tiJLgn\u001a\u0011pM\u0002\u00027\u000f\u001e:aAQD\u0017\r\u001e\u0011ti\u0006\u0014Ho\u001d\u0011bi\u0002\u0002\u0007o\\:aA\u0005tG\rI5tA=4\u0007\u0005\\3oORD\u0007\u0005\u00197f]\u0002d\u0003e\u001c:!i\",\u0007e\u001d7jG\u0016\u0004sN\u001a\u0011csR,\u0007%\u0019:sCf\u0004C\u000f[1uAM$\u0018M\u001d;tA\u0005$\b\u0005\u00199pg\u0002\u0004\u0013M\u001c3!SN\u0004sN\u001a\u0011mK:<G\u000f\u001b\u0011aY\u0016t\u0007M\f\u0006\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006f\u001d;sA\u0019\u0013v*\u0014\u0011q_N\\\u0006ER(SA1,g.X/*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fAM,(m\u001d;sS:<\u0007e\u001c4!AN$(\u000f\u0019\u0011uQ\u0006$\be\u001d;beR\u001c\b%\u0019;!AB|7\u000f\u0019\u0011b]\u0012\u0004\u0013n\u001d\u0011pM\u0002bWM\\4uQ\u0002\u0002G.\u001a8aY\u0001z'\u000f\t;iK\u0002\u001aH.[2fA=4\u0007EY=uK\u0002\n'O]1zAQD\u0017\r\u001e\u0011ti\u0006\u0014Ho\u001d\u0011bi\u0002\u0002\u0007o\\:aA\u0005tG\rI5tA=4\u0007\u0005\\3oORD\u0007\u0005\u00197f]\u0002t#\u0002\t\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a,\u0002\u0007gQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO1\u0002S'K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!W\u0002\u001a\u0016\u000b\u0014\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OM\u0003\u0018M]6!'Fcu\u0005\f\u0011.g%Z$\u0002\t\u0011!A\u0001\u0002\u0003eU)M\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\":3\u000b]1sW\u0002\u001a\u0016\u000bT\u0014-AUb\u0003%M\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!A-T\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO\u00012%kT'!k%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001b\u0011T#2S\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006fJ*qCJ\\\u0007eU)MO\u00012%kT'![MJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*R\u0019*\u0001\u0003\u0005\t\u0011!Ay\u00023+\u0012'F\u0007R\u0003sLR+O\u0007~Cse\u00159be.\u00043+\u0015'(A\u0019\u0013v*\u0014\u00116A\u0019{%\u000bI\u0019*w)\u0001\u0003\u0005\t\u0011!A\u0001Z'\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\fK3oG>$W\rK\u0014Ta\u0006\u00148\u000eI*R\u0019\u001eb\u0003eJ;uM6Bt%\u000b\u0017!k%Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u001b\u0011T#2S\u0001\u0005I\u0001\u0006g&t7-Z\u0011\u0003\u0003k\u000bQ!\r\u00186]A\nQa\u001a:pkB\f#!a/\u0002\u0019M$(/\u001b8h?\u001a,hnY:\u0002\u0013M+(m\u001d;sS:<\u0007C\u0001\u001b\u001f'\u0015q\u00121YAh!!\t)-a3O\u001d:CVBAAd\u0015\r\tI\rP\u0001\beVtG/[7f\u0013\u0011\ti-a2\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t7\u0007\u0005\u0003\u0002R\u0006]WBAAj\u0015\u0011\t).!\u0019\u0002\u0005%|\u0017b\u0001&\u0002TR\u0011\u0011qX\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011L\u0001\u0006CB\u0004H.\u001f\u000b\b1\u0006\r\u0018Q]At\u0011\u0015a\u0015\u00051\u0001O\u0011\u0015\u0011\u0016\u00051\u0001O\u0011\u0015!\u0016\u00051\u0001O\u0003\u001d)h.\u00199qYf$B!!<\u0002zB)1(a<\u0002t&\u0019\u0011\u0011\u001f\u001f\u0003\r=\u0003H/[8o!\u0019Y\u0014Q\u001f(O\u001d&\u0019\u0011q\u001f\u001f\u0003\rQ+\b\u000f\\34\u0011!\tYPIA\u0001\u0002\u0004A\u0016a\u0001=%a\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!\u0011\u0001\t\u0005\u00037\u0012\u0019!\u0003\u0003\u0003\u0006\u0005u#AB(cU\u0016\u001cG\u000f")
public class Substring
extends TernaryExpression
implements ImplicitCastInputTypes,
Serializable {
    private final Expression str;
    private final Expression pos;
    private final Expression len;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(Substring x$0) {
        return Substring$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, Substring> tupled() {
        return Substring$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, Substring>>> curried() {
        return Substring$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression str() {
        return this.str;
    }

    public Expression pos() {
        return this.pos;
    }

    public Expression len() {
        return this.len;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public DataType dataType() {
        return this.str().dataType();
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)TypeCollection$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{StringTypeWithCollation$.MODULE$.apply(true, StringTypeWithCollation$.MODULE$.apply$default$2(), StringTypeWithCollation$.MODULE$.apply$default$3()), BinaryType$.MODULE$})), (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$)));
    }

    @Override
    public Expression first() {
        return this.str();
    }

    @Override
    public Expression second() {
        return this.pos();
    }

    @Override
    public Expression third() {
        return this.len();
    }

    @Override
    public Object nullSafeEval(Object string, Object pos, Object len) {
        DataType dataType = this.str().dataType();
        if (dataType instanceof StringType) {
            return ((UTF8String)string).substringSQL(BoxesRunTime.unboxToInt((Object)pos), BoxesRunTime.unboxToInt((Object)len));
        }
        if (BinaryType$.MODULE$.equals(dataType)) {
            return ByteArray.subStringSQL((byte[])((byte[])string), (int)BoxesRunTime.unboxToInt((Object)pos), (int)BoxesRunTime.unboxToInt((Object)len));
        }
        throw new MatchError((Object)dataType);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.defineCodeGen(ctx, ev, (Function3<String, String, String, String>)(Function3 & Serializable)(string, pos, len) -> {
            DataType dataType = this.str().dataType();
            if (dataType instanceof StringType) {
                return string + ".substringSQL(" + pos + ", " + len + ")";
            }
            if (BinaryType$.MODULE$.equals(dataType)) {
                return ByteArray.class.getName() + ".subStringSQL(" + string + ", " + pos + ", " + len + ")";
            }
            throw new MatchError((Object)dataType);
        });
    }

    @Override
    public Substring withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    public Substring copy(Expression str, Expression pos, Expression len) {
        return new Substring(str, pos, len);
    }

    public Expression copy$default$1() {
        return this.str();
    }

    public Expression copy$default$2() {
        return this.pos();
    }

    public Expression copy$default$3() {
        return this.len();
    }

    @Override
    public String productPrefix() {
        return "Substring";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.str();
            }
            case 1: {
                return this.pos();
            }
            case 2: {
                return this.len();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Substring;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "str";
            }
            case 1: {
                return "pos";
            }
            case 2: {
                return "len";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Substring)) return false;
        boolean bl = true;
        if (!bl) return false;
        Substring substring = (Substring)x$1;
        Expression expression = this.str();
        Expression expression2 = substring.str();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.pos();
        Expression expression4 = substring.pos();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.len();
        Expression expression6 = substring.len();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!substring.canEqual(this)) return false;
        return true;
    }

    public Substring(Expression str, Expression pos, Expression len) {
        this.str = str;
        this.pos = pos;
        this.len = len;
        ExpectsInputTypes.$init$(this);
    }

    public Substring(Expression str, Expression pos) {
        this(str, pos, Literal$.MODULE$.apply(BoxesRunTime.boxToInteger((int)Integer.MAX_VALUE)));
    }
}

